/*
 * Decompiled with CFR 0.152.
 */
package flare.eventbus;

import flare.commons.ReflectionUtil;
import flare.commons.WeakIdentityHashMap;
import flare.eventbus.ClassHierarchyService;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

final class CachedClassHierarchyService
implements ClassHierarchyService {
    static final CachedClassHierarchyService INSTANCE = new CachedClassHierarchyService();
    private final AtomicReference<Map<Class<?>, Class<?>[]>> map = new AtomicReference<WeakIdentityHashMap>(new WeakIdentityHashMap());

    private CachedClassHierarchyService() {
    }

    @Override
    public <T> Class<? super T>[] superTypesOf(Class<T> clazz) {
        Map<Class<?>, Class<?>[]> map = this.map.get();
        Class<?>[] superTypes = map.get(clazz);
        return superTypes == null ? this.updateSuperTypes(clazz) : superTypes;
    }

    private synchronized <T> Class<? super T>[] updateSuperTypes(Class<T> clazz) {
        Map<Class<?>, Class<?>[]> map = this.map.get();
        Class<?>[] superTypes = map.get(clazz);
        if (superTypes != null) {
            return superTypes;
        }
        superTypes = (Class[])ReflectionUtil.traverseSuperTypes(clazz).toArray(Class[]::new);
        map.put(clazz, superTypes);
        this.map.lazySet(map);
        return superTypes;
    }
}

