/*
 * Decompiled with CFR 0.152.
 */
package flare.eventbus;

import flare.eventbus.EventContext;
import flare.eventbus.EventHandler;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

final class BuiltEventListener<T>
implements EventHandler<T> {
    private final boolean ignoreCancelled;
    @Nullable
    private final AtomicInteger expirationCount;
    @Nullable
    private final Predicate<T> expireWhen;
    @Nullable
    private final Predicate<T>[] filters;
    private final Consumer<T> handler;

    BuiltEventListener(boolean ignoreCancelled, @Nullable AtomicInteger expirationCount, @Nullable Predicate<T> expireWhen, @Nullable Predicate<T>[] filters, Consumer<T> handler) {
        this.ignoreCancelled = ignoreCancelled;
        this.expirationCount = expirationCount;
        this.expireWhen = expireWhen;
        this.filters = filters;
        this.handler = handler;
    }

    @Override
    public EventHandler.Result handle(T event, EventContext context) {
        if (this.ignoreCancelled && context.isCancelled()) {
            return EventHandler.Result.INVALID;
        }
        if (this.expireWhen != null && this.expireWhen.test(event)) {
            return EventHandler.Result.EXPIRED;
        }
        if (this.filters != null) {
            for (int i = 0; i < this.filters.length; ++i) {
                if (this.filters[i].test(event)) continue;
                return EventHandler.Result.INVALID;
            }
        }
        this.handler.accept(event);
        if (this.expirationCount != null && this.expirationCount.decrementAndGet() == 0) {
            return EventHandler.Result.EXPIRED;
        }
        return EventHandler.Result.SUCCESS;
    }
}

