/*
 * Decompiled with CFR 0.152.
 */
package flare.eventbus;

import flare.eventbus.EventDispatcher;
import flare.eventbus.EventHandler;
import flare.eventbus.EventSubscriber;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Set;

final class HashEventDispatcher<E>
implements EventDispatcher<E> {
    private final Set<EventSubscriber<E>> subscribers = new ReferenceOpenHashSet();
    private EventSubscriber<E>[] sortedSubscribers = new EventSubscriber[0];

    HashEventDispatcher() {
    }

    @Override
    public boolean register(EventSubscriber<E> subscriber) {
        if (this.subscribers.add(subscriber)) {
            this.sortSubscribers();
            return true;
        }
        return false;
    }

    @Override
    public boolean unregister(EventSubscriber<E> subscriber) {
        if (this.subscribers.remove(subscriber)) {
            this.sortSubscribers();
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSubscribers() {
        return !this.subscribers.isEmpty();
    }

    private void sortSubscribers() {
        this.sortedSubscribers = (EventSubscriber[])this.subscribers.stream().sorted().toArray(EventSubscriber[]::new);
    }

    @Override
    public boolean dispatch(E event) {
        boolean changed = false;
        for (int i = 0; i < this.sortedSubscribers.length; ++i) {
            changed |= this.dispatchTo(event, this.sortedSubscribers[i]);
        }
        if (changed) {
            this.sortSubscribers();
        }
        return changed;
    }

    private boolean dispatchTo(E event, EventSubscriber<E> subscriber) {
        return switch (subscriber.handler().handle(event)) {
            case EventHandler.Result.EXPIRED -> this.subscribers.remove(subscriber);
            default -> false;
        };
    }
}

