/*
 * Decompiled with CFR 0.152.
 */
package flare.eventbus;

import flare.eventbus.AnnotatedSubscriberUtil;
import flare.eventbus.ClassHierarchyService;
import flare.eventbus.EventBus;
import flare.eventbus.EventDispatcher;
import flare.eventbus.EventSubscriber;
import flare.eventbus.HashEventDispatcher;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

final class EventBusImpl<T>
implements EventBus<T> {
    private final Class<T> eventType;
    @Nullable
    private final ClassHierarchyService hierarchyService;
    private final Map<Object, EventSubscriber<? extends T>[]> annotatedSubscribers = new IdentityHashMap<Object, EventSubscriber<? extends T>[]>();
    private final Map<Class<? extends T>, EventDispatcher<? extends T>> dispatchers = new IdentityHashMap<Class<? extends T>, EventDispatcher<? extends T>>();
    private final Set<EventBusImpl<? extends T>> children = new ReferenceOpenHashSet();
    private EventBus<? extends T>[] activeChildren = new EventBus[0];
    @Nullable
    private EventBusImpl<? super T> parent;
    private boolean active;

    EventBusImpl(Class<T> eventType, @Nullable ClassHierarchyService hierarchyService) {
        this.eventType = eventType;
        this.hierarchyService = hierarchyService;
    }

    private <E extends T> boolean dispatchAs(E event, Class<? super E> eventType) {
        EventDispatcher<E> dispatcher = this.dispatchers.get(eventType);
        if (dispatcher != null) {
            dispatcher.dispatch(event);
            return !dispatcher.hasSubscribers();
        }
        return false;
    }

    @Override
    public <E extends T> boolean post(E event) {
        Class<E> eventType = EventBusImpl.typeOf(event);
        for (int i = 0; i < this.activeChildren.length; ++i) {
            EventBus<T> child = this.activeChildren[i];
            if (!child.eventType().isAssignableFrom(eventType)) continue;
            ((EventBusImpl)child).post(event);
        }
        boolean checkActive = false;
        checkActive |= this.dispatchAs(event, eventType);
        if (this.hierarchyService != null) {
            Class<E>[] superTypes = this.hierarchyService.superTypesOf(eventType);
            for (int i = 0; i < superTypes.length; ++i) {
                Class<E> superType = superTypes[i];
                checkActive |= this.dispatchAs(event, superTypes[i]);
                if (superType == this.eventType) break;
            }
        }
        if (checkActive) {
            this.checkActive();
        }
        return false;
    }

    @Override
    public Class<T> eventType() {
        return this.eventType;
    }

    @Override
    public Optional<EventBus<? super T>> parent() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    public Set<EventBus<? extends T>> children() {
        return Collections.unmodifiableSet(this.children);
    }

    @Override
    public <E extends T> EventBus<T> addChild(EventBus<E> child) {
        EventBusImpl<E> childImpl = EventBusImpl.asImpl(child);
        if (this.children.add(childImpl)) {
            childImpl.parent = this;
            this.updateActiveChildren();
            this.checkActive();
        }
        return this;
    }

    @Override
    public <E extends T> EventBus<T> removeChild(EventBus<E> child) {
        EventBusImpl<E> childImpl = EventBusImpl.asImpl(child);
        if (this.children.remove(childImpl)) {
            childImpl.parent = null;
            this.updateActiveChildren();
            this.checkActive();
        }
        return this;
    }

    @Override
    public EventBus<T> subscribeAnnotated(Object obj) {
        this.annotatedSubscribers.computeIfAbsent(obj, __ -> (EventSubscriber[])AnnotatedSubscriberUtil.findAnnotatedSubscribers(obj, this.eventType).peek(this::subscribe).toArray(EventSubscriber[]::new));
        return this;
    }

    @Override
    public EventBus<T> unsubscribeAnnotated(Object obj) {
        EventSubscriber<? extends T>[] listeners = this.annotatedSubscribers.remove(obj);
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                this.unsubscribe(listeners[i]);
            }
        }
        return this;
    }

    @Override
    public <E extends T> EventBus<T> subscribe(EventSubscriber<E> subscriber) {
        EventDispatcher<E> dispatcher = this.dispatchers.get(subscriber.eventType());
        if (dispatcher == null) {
            dispatcher = new HashEventDispatcher<T>();
            this.dispatchers.put(subscriber.eventType(), dispatcher);
            this.checkActive();
        }
        dispatcher.register(subscriber);
        return this;
    }

    @Override
    public <E extends T> EventBus<T> unsubscribe(EventSubscriber<E> subscriber) {
        EventDispatcher<E> dispatcher = this.dispatchers.get(subscriber.eventType());
        if (dispatcher == null) {
            return this;
        }
        if (dispatcher.unregister(subscriber) && !dispatcher.hasSubscribers()) {
            this.dispatchers.remove(subscriber.eventType());
            this.checkActive();
        }
        return this;
    }

    private void checkActive() {
        boolean active;
        boolean bl = active = this.activeChildren.length > 0 || !this.dispatchers.isEmpty();
        if (active == this.active) {
            return;
        }
        this.active = active;
        if (this.parent != null) {
            this.parent.updateActiveChildren();
        }
    }

    private boolean isActive() {
        return this.active;
    }

    private void updateActiveChildren() {
        this.activeChildren = (EventBus[])this.children.stream().filter(EventBusImpl::isActive).toArray(EventBusImpl[]::new);
    }

    private static <T> Class<T> typeOf(T object) {
        return object.getClass();
    }

    private static <T> EventBusImpl<T> asImpl(EventBus<T> eventNode) {
        return (EventBusImpl)eventNode;
    }
}

