/*
 * Decompiled with CFR 0.152.
 */
package flare.eventbus;

import com.esotericsoftware.reflectasm.MethodAccess;
import flare.commons.ReflectionUtil;
import flare.eventbus.EventHandler;
import flare.eventbus.EventSubscriber;
import flare.eventbus.Subscribe;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

final class AnnotatedSubscriberUtil {
    private AnnotatedSubscriberUtil() {
    }

    static <T> Stream<EventSubscriber<? extends T>> findAnnotatedSubscribers(Object obj, Class<T> superEventType) {
        return obj.getClass() == Class.class ? AnnotatedSubscriberUtil.findStaticAnnotatedSubscribers((Class)obj, superEventType) : AnnotatedSubscriberUtil.findInstanceAnnotatedSubscribers(obj, superEventType);
    }

    private static <T> Stream<EventSubscriber<? extends T>> findStaticAnnotatedSubscribers(Class<?> clazz, Class<T> superEventType) {
        return Arrays.stream(clazz.getMethods()).filter(method -> Modifier.isStatic(method.getModifiers())).filter(method -> method.isAnnotationPresent(Subscribe.class)).map(method -> AnnotatedSubscriberUtil.createSubscriber(null, method, method, superEventType));
    }

    private static <T> Stream<EventSubscriber<? extends T>> findInstanceAnnotatedSubscribers(Object instance, Class<T> superEventType) {
        Set superTypes = ReflectionUtil.traverseSuperTypes(instance.getClass());
        return Arrays.stream(instance.getClass().getMethods()).filter(m -> !Modifier.isStatic(m.getModifiers())).flatMap(method -> Stream.concat(superTypes.stream(), Stream.of(instance.getClass())).flatMap(clazz -> AnnotatedSubscriberUtil.getDeclaredMethod(clazz, method).stream()).filter(declaredMethod -> declaredMethod.isAnnotationPresent(Subscribe.class)).findFirst().map(declaredMethod -> AnnotatedSubscriberUtil.createSubscriber(instance, method, declaredMethod, superEventType)).stream());
    }

    private static <T> EventSubscriber<? extends T> createSubscriber(@Nullable Object instance, Method method, Method declaredMethod, Class<T> superEventType) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            throw new IllegalArgumentException("Method " + method + " has @Subscribe annotation. It has " + parameterTypes.length + " arguments, but event handler methods require a single argument only.");
        }
        Class<?> eventType = parameterTypes[0];
        if (!superEventType.isAssignableFrom(eventType) && !superEventType.isAssignableFrom(eventType)) {
            throw new IllegalArgumentException("Method " + method + " has @Subscribe annotation, but takes an argument that is not assignable from: " + superEventType);
        }
        Subscribe annotation = declaredMethod.getAnnotation(Subscribe.class);
        return AnnotatedSubscriberUtil.createSubscriber(instance, declaredMethod, eventType, annotation);
    }

    private static <T> EventSubscriber<T> createSubscriber(@Nullable Object instance, Method method, Class<T> eventType, Subscribe annotation) {
        return new EventSubscriber<T>(eventType, EventHandler.builder().ignoreCancelled(annotation.ignoreCancelled()).expirationCount(annotation.expirationCount()).build(AnnotatedSubscriberUtil.createMethodInvokingHandler(instance, method, eventType)), annotation.priority());
    }

    private static Optional<Method> getDeclaredMethod(Class<?> clazz, Method method) {
        try {
            return Optional.of(clazz.getDeclaredMethod(method.getName(), method.getParameterTypes()));
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
    }

    private static <T> Consumer<T> createMethodInvokingHandler(@Nullable Object instance, Method listenerMethod, Class<T> eventType) {
        MethodAccess handlerAccess = MethodAccess.get(listenerMethod.getDeclaringClass());
        int methodIndex = handlerAccess.getIndex(listenerMethod.getName(), new Class[]{eventType});
        return event -> handlerAccess.invoke(instance, methodIndex, new Object[]{event});
    }
}

