package flare.eventbus;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotated methods are automatically discovered and subscribed by
 * {@link EventBus#subscribeAnnotated(Object)}.
 */
@Retention(value = RetentionPolicy.RUNTIME)
@Target(value = ElementType.METHOD)
public @interface Subscribe {

  /**
   * @see EventSubscriber#priority()
   */
  int priority() default EventSubscriber.NORMAL_PRIORITY;

  /**
   * Whether cancelled events should be handled or ignored by the annotated method.
   */
  boolean ignoreCancelled() default true;

  /**
   * Maximum number of executions until the subscription expires.<br>
   * Values less than 1 mean the subscription will never expire.
   */
  int expirationCount() default 0;
}
