package flare.eventbus;

/**
 * Manages {@link EventSubscriber}s for a single event type.
 *
 * @param <T> - the event type
 */
public interface EventDispatcher<T> {

  /**
   * Registers an {@link EventSubscriber}.
   * 
   * @param subscriber - subscriber to register
   * @return {@code true} if this dispatcher did not already contain the specified subscriber
   */
  boolean register(EventSubscriber<T> subscriber);

  /**
   * Unregisters an {@link EventSubscriber}.
   * 
   * @param subscriber - subscriber to unregister
   * @return {@code true} if this dispatcher contained the specified subscriber
   */
  boolean unregister(EventSubscriber<T> subscriber);

  /**
   * @return {@code true} if this dispatcher contains no subscribers
   */
  boolean hasSubscribers();

  /**
   * Dispatches the specified event to all subscribers contained within this dispatcher.
   * 
   * @param event - event to dispatch
   * @return {@code true} if subscribers were removed as a result of the dispatch
   */
  boolean dispatch(T event);
}
