/*
 * Decompiled with CFR 0.152.
 */
package flare.commons;

public enum DataType {
    BOOLEAN(1, Boolean.TYPE, false),
    UNSIGNED_BYTE(1, Byte.class, false),
    BYTE(1, Byte.TYPE, false),
    UNSIGNED_SHORT(2, Short.TYPE, false),
    SHORT(2, Short.TYPE, false),
    UNSIGNED_INT(4, Integer.TYPE, false),
    INT(4, Integer.TYPE, false),
    UNSIGNED_LONG(8, Long.TYPE, false),
    LONG(8, Long.TYPE, false),
    FLOAT(4, Float.TYPE, true),
    DOUBLE(8, Double.TYPE, true);

    private final int size;
    private final Class<?> type;
    private final boolean floatingPoint;

    private DataType(int size, Class<?> type, boolean floatingPoint) {
        this.size = size;
        this.type = type;
        this.floatingPoint = floatingPoint;
    }

    public int size() {
        return this.size;
    }

    public Class<?> type() {
        return this.type;
    }

    public boolean floatingPoint() {
        return this.floatingPoint;
    }

    public static DataType least(int count) {
        if ((count & 0xFFFF0000) != 0) {
            return INT;
        }
        return (count & 0xFF00) != 0 ? SHORT : BYTE;
    }
}

