package flare.commons;

import java.util.LinkedHashSet;
import java.util.Set;

public final class ReflectionUtil {

  private ReflectionUtil() {}

  public static <T> Set<Class<? super T>> traverseSuperTypes(Class<T> clazz) {
    Set<Class<? super T>> traversed = new LinkedHashSet<>();
    traverseSuperTypes(clazz, traversed);
    return traversed;
  }

  @SuppressWarnings("unchecked")
  private static <T> void traverseSuperTypes(Class<T> clazz,
      Set<? super Class<? super T>> traversed) {
    var interfaces = clazz.getInterfaces();
    for (int i = 0; i < interfaces.length; i++) {
      var interf = (Class<? super T>) interfaces[i];
      traversed.add(interf);
      traverseSuperTypes(interf, traversed);
    }
    var superclass = clazz.getSuperclass();
    if (superclass != null) {
      traversed.add(superclass);
      traverseSuperTypes(superclass, traversed);
    }
  }
}
