package flare.commons;

import com.fasterxml.jackson.annotation.JsonProperty;

public enum DataType {

  @JsonProperty("boolean")
  BOOLEAN(Byte.BYTES, boolean.class, false),
  @JsonProperty("unsigned_byte")
  UNSIGNED_BYTE(Byte.BYTES, Byte.class, false),
  @JsonProperty("byte")
  BYTE(Byte.BYTES, byte.class, false),
  @JsonProperty("unisgned_short")
  UNSIGNED_SHORT(Short.BYTES, short.class, false),
  @JsonProperty("short")
  SHORT(Short.BYTES, short.class, false),
  @JsonProperty("unsigned_int")
  UNSIGNED_INT(Integer.BYTES, int.class, false),
  @JsonProperty("int")
  INT(Integer.BYTES, int.class, false),
  @JsonProperty("unsigned_long")
  UNSIGNED_LONG(Long.BYTES, long.class, false),
  @JsonProperty("long")
  LONG(Long.BYTES, long.class, false),
  @JsonProperty("float")
  FLOAT(Float.BYTES, float.class, true),
  @JsonProperty("double")
  DOUBLE(Double.BYTES, double.class, true);

  private final int size;
  private final Class<?> type;
  private final boolean floatingPoint;

  private DataType(int size, Class<?> type, boolean floatingPoint) {
    this.size = size;
    this.type = type;
    this.floatingPoint = floatingPoint;
  }

  public int size() {
    return this.size;
  }

  public Class<?> type() {
    return this.type;
  }

  public boolean floatingPoint() {
    return this.floatingPoint;
  }

  public static DataType least(int count) {
    if ((count & 0xFFFF0000) != 0) {
      return INT;
    } else {
      return (count & 0x0000FF00) != 0 ? SHORT : BYTE;
    }
  }
}
