package flare.commons;

public class ColorUtil {

  private static final int ALPHA_OFFSET = 24;
  private static final int BLUE_OFFSET = 16;
  private static final int GREEN_OFFSET = 8;
  private static final int RED_OFFSET = 0;

  public static int alpha(int rgba) {
    return rgba >> ALPHA_OFFSET & 255;
  }

  public static int red(int rgba) {
    return rgba >> RED_OFFSET & 255;
  }

  public static int green(int rgba) {
    return rgba >> GREEN_OFFSET & 255;
  }

  public static int blue(int rgba) {
    return rgba >> BLUE_OFFSET & 255;
  }

  public static int combine(int red, int green, int blue, int alpha) {
    return (alpha & 255) << ALPHA_OFFSET
        | (blue & 255) << BLUE_OFFSET
        | (green & 255) << GREEN_OFFSET
        | (red & 255) << RED_OFFSET;
  }
}
