/*
 * Decompiled with CFR 0.152.
 */
package flare.commons;

import java.util.LinkedHashSet;
import java.util.Set;

public final class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static <T> Set<Class<? super T>> traverseSuperTypes(Class<T> clazz) {
        LinkedHashSet<Class<? super T>> traversed = new LinkedHashSet<Class<? super T>>();
        ReflectionUtil.traverseSuperTypes(clazz, traversed);
        return traversed;
    }

    private static <T> void traverseSuperTypes(Class<T> clazz, Set<? super Class<? super T>> traversed) {
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> interf = interfaces[i];
            traversed.add(interf);
            ReflectionUtil.traverseSuperTypes(interf, traversed);
        }
        Class<T> superclass = clazz.getSuperclass();
        if (superclass != null) {
            traversed.add(superclass);
            ReflectionUtil.traverseSuperTypes(superclass, traversed);
        }
    }
}

