/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.survival.world.item;

import com.craftingdead.core.world.action.item.ItemActionType;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class MultiActionItem
extends Item {
    private final List<Supplier<? extends ItemActionType<?>>> actionTypes;

    @SafeVarargs
    public MultiActionItem(Item.Properties properties, Supplier<? extends ItemActionType<?>> ... actionTypes) {
        super(properties);
        this.actionTypes = List.of(actionTypes);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (!context.m_43725_().m_5776_()) {
            PlayerExtension performer = PlayerExtension.getOrThrow((Player)context.m_43723_());
            for (Supplier<ItemActionType<?>> actionTypeSupplier : this.actionTypes) {
                ItemActionType<?> actionType = actionTypeSupplier.get();
                if (!actionType.createBlockAction((LivingExtension)performer, context).map(action -> performer.performAction(action, true)).orElse(false).booleanValue()) continue;
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResult m_6880_(ItemStack itemStack, Player player, LivingEntity targetEntity, InteractionHand hand) {
        if (!player.m_183503_().m_5776_()) {
            PlayerExtension performer = PlayerExtension.getOrThrow((Player)player);
            LivingExtension target = LivingExtension.getOrThrow((LivingEntity)targetEntity);
            for (Supplier<ItemActionType<?>> actionTypeSupplier : this.actionTypes) {
                ItemActionType<?> actionType = actionTypeSupplier.get();
                if (!actionType.createEntityAction((LivingExtension)performer, target, hand).map(action -> performer.performAction(action, true)).orElse(false).booleanValue()) continue;
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (!player.m_183503_().m_5776_()) {
            ItemActionType<?> actionType;
            PlayerExtension performer = PlayerExtension.getOrThrow((Player)player);
            BlockHitResult hitResult = MultiActionItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
            if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
                for (Supplier<ItemActionType<?>> actionTypeSupplier : this.actionTypes) {
                    actionType = actionTypeSupplier.get();
                    if (!actionType.createBlockAction((LivingExtension)performer, new UseOnContext(player, hand, hitResult)).map(action -> performer.performAction(action, true)).orElse(false).booleanValue()) continue;
                    return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
                }
            }
            for (Supplier<ItemActionType<?>> actionTypeSupplier : this.actionTypes) {
                actionType = actionTypeSupplier.get();
                if (!actionType.createAction((LivingExtension)performer, hand).map(action -> performer.performAction(action, true)).orElse(false).booleanValue()) continue;
                return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
            }
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    public int m_8105_(ItemStack itemStack) {
        return this.actionTypes.stream().map(Supplier::get).mapToInt(ItemActionType::getDurationTicks).max().orElse(0);
    }
}

