/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.survival.world.item;

import com.craftingdead.core.capability.CapabilityUtil;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.immerse.game.survival.SurvivalPlayerHandler;
import com.craftingdead.immerse.world.item.hydration.Hydration;
import com.craftingdead.survival.CraftingDeadSurvival;
import com.craftingdead.survival.world.item.ConsumableConfigOverrides;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;

public class ConsumableItem
extends Item {
    private final int water;
    private final Supplier<Item> emptyItem;
    private final FoodProperties foodProperties;
    private final Type type;

    public ConsumableItem(Item.Properties properties, int nutrition, float saturation, int water, Supplier<Item> emptyItem, Type type) {
        super(properties);
        this.water = type != Type.ONLY_FOOD ? water : 0;
        this.emptyItem = emptyItem;
        this.foodProperties = type == Type.ONLY_FOOD || type == Type.FOOD_AND_DRINK ? new FoodProperties.Builder().m_38760_(nutrition).m_38758_(saturation).m_38767_() : null;
        this.type = type;
    }

    public ICapabilityProvider initCapabilities(ItemStack itemStack, @Nullable CompoundTag tag) {
        return this.type != Type.ONLY_FOOD && CraftingDeadSurvival.instance().isImmerseLoaded() ? ConsumableItem.createHydrationProvider(itemStack.m_41720_(), this.water) : null;
    }

    private static ICapabilityProvider createHydrationProvider(Item item, int defaultWater) {
        ConsumableConfigOverrides.DrinkOverride override;
        int water = defaultWater;
        water = ConsumableConfigOverrides.isLoaded() ? ((override = ConsumableConfigOverrides.getDrinkOverride(Registry.f_122827_.m_7981_((Object)item))) != null && override.hydration() != null ? override.hydration() : (int)Math.round((double)water * (Double)CraftingDeadSurvival.serverConfig.drinkHydrationMultiplier.get())) : (int)Math.round((double)water * (Double)CraftingDeadSurvival.serverConfig.drinkHydrationMultiplier.get());
        int finalWater = water;
        return CapabilityUtil.provider(() -> Hydration.fixed((int)finalWater), (Capability[])new Capability[]{Hydration.CAPABILITY});
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        boolean canConsume = this.type == Type.ONLY_FOOD && this.canEat(player) || this.type == Type.FOOD_AND_DRINK && (this.canEat(player) || this.canDrink(player)) || this.type == Type.ONLY_DRINK && this.canDrink(player) && CraftingDeadSurvival.instance().isImmerseLoaded();
        return canConsume ? ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)hand) : InteractionResultHolder.m_19100_((Object)player.m_21120_(hand));
    }

    public void m_5929_(@NotNull Level level, @NotNull LivingEntity entity, @NotNull ItemStack stack, int remainingUseDuration) {
        boolean consumption;
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        boolean needsFood = this.canEat(player);
        boolean needsWater = CraftingDeadSurvival.instance().isImmerseLoaded() && this.canDrink(player);
        switch (this.type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case ONLY_FOOD: {
                boolean bl = needsFood;
                break;
            }
            case ONLY_DRINK: {
                boolean bl = needsWater;
                break;
            }
            case FOOD_AND_DRINK: {
                boolean bl = consumption = needsFood || needsWater;
            }
        }
        if (!consumption) {
            player.m_21253_();
        }
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull LivingEntity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            CriteriaTriggers.f_10592_.m_23682_(serverPlayer, itemStack);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.applyEffects(player);
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
                if (this.emptyItem != null) {
                    ItemStack emptyStack = new ItemStack((ItemLike)this.emptyItem.get());
                    if (!player.m_150109_().m_36054_(emptyStack)) {
                        player.m_19983_(emptyStack);
                    }
                }
            }
        }
        this.triggerConsumptionEvent(level, entity);
        return itemStack;
    }

    private void applyEffects(Player player) {
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        if (this.foodProperties != null) {
            int nutrition = this.foodProperties.m_38744_();
            float saturation = this.foodProperties.m_38745_();
            if (ConsumableConfigOverrides.isLoaded()) {
                ConsumableConfigOverrides.FoodOverride override = ConsumableConfigOverrides.getFoodOverride(Registry.f_122827_.m_7981_((Object)this));
                if (override != null) {
                    nutrition = override.nutrition() != null ? override.nutrition() : (int)Math.round((double)nutrition * (Double)CraftingDeadSurvival.serverConfig.foodNutritionMultiplier.get());
                    saturation = override.saturation() != null ? override.saturation().floatValue() : (float)((double)saturation * (Double)CraftingDeadSurvival.serverConfig.foodSaturationMultiplier.get());
                } else {
                    nutrition = (int)Math.round((double)nutrition * (Double)CraftingDeadSurvival.serverConfig.foodNutritionMultiplier.get());
                    saturation = (float)((double)saturation * (Double)CraftingDeadSurvival.serverConfig.foodSaturationMultiplier.get());
                }
            } else {
                nutrition = (int)Math.round((double)nutrition * (Double)CraftingDeadSurvival.serverConfig.foodNutritionMultiplier.get());
                saturation = (float)((double)saturation * (Double)CraftingDeadSurvival.serverConfig.foodSaturationMultiplier.get());
            }
            player.m_36324_().m_38707_(nutrition, saturation);
        }
    }

    private void triggerConsumptionEvent(Level level, LivingEntity entity) {
        GameEvent event = this.type == Type.ONLY_DRINK ? GameEvent.f_157805_ : GameEvent.f_157806_;
        level.m_142346_((Entity)entity, event, entity.m_146901_());
    }

    public int m_8105_(@NotNull ItemStack itemStack) {
        return 32;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack itemStack) {
        return this.type == Type.ONLY_DRINK ? UseAnim.DRINK : UseAnim.EAT;
    }

    private boolean canEat(Player player) {
        return player.m_36324_().m_38702_() < 20;
    }

    private boolean canDrink(Player player) {
        SurvivalPlayerHandler handler = (SurvivalPlayerHandler)PlayerExtension.getOrThrow((Player)player).getHandlerOrThrow(SurvivalPlayerHandler.TYPE);
        return handler.getWater() < handler.getMaxWater();
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        if (this.foodProperties != null) {
            tooltip.add((Component)new TranslatableComponent("item.craftingdeadsurvival.consumable.food_info").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(" " + this.foodProperties.m_38744_()).m_130940_(ChatFormatting.RED)));
        }
        if (this.water > 0) {
            tooltip.add((Component)new TranslatableComponent("item.craftingdeadsurvival.consumable.water_info").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(" " + this.water).m_130940_(ChatFormatting.RED)));
        }
    }

    public static enum Type {
        ONLY_FOOD,
        ONLY_DRINK,
        FOOD_AND_DRINK;

    }
}

