/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.survival.world.item;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.loading.FMLPaths;
import org.slf4j.Logger;

public class ConsumableConfigOverrides {
    private static final Logger logger = LogUtils.getLogger();
    private static final Path CONFIG_FILE = FMLPaths.CONFIGDIR.get().resolve("craftingdead").resolve("items").resolve("consumables.toml");
    private static final Map<ResourceLocation, FoodOverride> foodOverrides = new HashMap<ResourceLocation, FoodOverride>();
    private static final Map<ResourceLocation, DrinkOverride> drinkOverrides = new HashMap<ResourceLocation, DrinkOverride>();
    private static boolean loaded = false;

    public static void loadOverrides() {
        foodOverrides.clear();
        drinkOverrides.clear();
        loaded = false;
        try {
            Object drinkSection;
            Object foodSection;
            Path configDir = CONFIG_FILE.getParent();
            if (!Files.exists(configDir, new LinkOption[0])) {
                Files.createDirectories(configDir, new FileAttribute[0]);
            }
            if (!Files.exists(CONFIG_FILE, new LinkOption[0])) {
                ConsumableConfigOverrides.createDefaultConfig();
            }
            CommentedFileConfig config = CommentedFileConfig.of((Path)CONFIG_FILE);
            config.load();
            if (config.contains("food_values") && (foodSection = config.get("food_values")) instanceof UnmodifiableConfig) {
                UnmodifiableConfig foodConfig = (UnmodifiableConfig)foodSection;
                foodConfig.valueMap().forEach((key, value) -> {
                    try {
                        ResourceLocation id = new ResourceLocation(key);
                        if (value instanceof UnmodifiableConfig) {
                            UnmodifiableConfig itemConfig = (UnmodifiableConfig)value;
                            Integer nutrition = itemConfig.contains("nutrition") ? Integer.valueOf(((Number)itemConfig.get("nutrition")).intValue()) : null;
                            Float saturation = itemConfig.contains("saturation") ? Float.valueOf(((Number)itemConfig.get("saturation")).floatValue()) : null;
                            foodOverrides.put(id, new FoodOverride(nutrition, saturation));
                            logger.debug("Loaded food override: {} -> nutrition={}, saturation={}", new Object[]{id, nutrition, saturation});
                        }
                    }
                    catch (Exception e) {
                        logger.error("Failed to parse food override for: {}", key, (Object)e);
                    }
                });
            }
            if (config.contains("drink_values") && (drinkSection = config.get("drink_values")) instanceof UnmodifiableConfig) {
                UnmodifiableConfig drinkConfig = (UnmodifiableConfig)drinkSection;
                drinkConfig.valueMap().forEach((key, value) -> {
                    try {
                        ResourceLocation id = new ResourceLocation(key);
                        if (value instanceof Number) {
                            Number number = (Number)value;
                            drinkOverrides.put(id, new DrinkOverride(number.intValue()));
                            logger.debug("Loaded drink override: {} -> hydration={}", (Object)id, (Object)number.intValue());
                        }
                    }
                    catch (Exception e) {
                        logger.error("Failed to parse drink override for: {}", key, (Object)e);
                    }
                });
            }
            config.close();
            loaded = true;
            logger.info("Loaded {} food override(s) and {} drink override(s)", (Object)foodOverrides.size(), (Object)drinkOverrides.size());
        }
        catch (IOException e) {
            logger.error("Failed to load consumable config", (Throwable)e);
        }
    }

    public static FoodOverride getFoodOverride(ResourceLocation itemId) {
        return foodOverrides.get(itemId);
    }

    public static DrinkOverride getDrinkOverride(ResourceLocation itemId) {
        return drinkOverrides.get(itemId);
    }

    public static boolean isLoaded() {
        return loaded;
    }

    private static void createDefaultConfig() {
        try {
            String defaultConfig = "# Crafting Dead - Consumables Configuration\n# Override food nutrition/saturation and drink hydration values per-item.\n# These overrides take precedence over global multipliers.\n# Format: \"mod:item_id\" = value (for drinks) or { nutrition = X, saturation = Y } (for food)\n\n[food_values]\n# Examples (disabled by default):\n# \"minecraft:bread\" = { nutrition = 5, saturation = 6.0 }\n# \"craftingdead:energy_bar\" = { nutrition = 8, saturation = 8.0 }\n# \"minecraft:golden_apple\" = { nutrition = 10, saturation = 12.0 }\n\n[drink_values]\n# Examples (disabled by default):\n# \"craftingdead:water_bottle\" = 10\n# \"craftingdead:dirty_water_bottle\" = 6\n# \"craftingdead:radiated_water_bottle\" = 4\n# \"craftingdead:coffee\" = 12\n";
            Files.writeString(CONFIG_FILE, (CharSequence)defaultConfig, new OpenOption[0]);
            logger.info("Created default consumables config at: {}", (Object)CONFIG_FILE);
        }
        catch (IOException e) {
            logger.error("Failed to create default consumables config", (Throwable)e);
        }
    }

    public record FoodOverride(Integer nutrition, Float saturation) {
    }

    public record DrinkOverride(Integer hydration) {
    }
}

