/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.survival.world.entity.extension;

import com.craftingdead.core.world.entity.extension.BasicLivingExtension;
import com.craftingdead.core.world.inventory.GunCraftSlotType;
import com.craftingdead.core.world.item.GunItem;
import com.craftingdead.core.world.item.MagazineItem;
import com.craftingdead.core.world.item.ModItems;
import com.craftingdead.core.world.item.equipment.Equipment;
import com.craftingdead.core.world.item.gun.Gun;
import com.craftingdead.core.world.item.gun.ammoprovider.AmmoProvider;
import com.craftingdead.core.world.item.gun.ammoprovider.RefillableAmmoProvider;
import com.craftingdead.core.world.item.gun.attachment.Attachment;
import com.craftingdead.core.world.item.gun.attachment.Attachments;
import com.craftingdead.survival.CraftingDeadSurvival;
import com.craftingdead.survival.world.entity.extension.ZombieHandler;
import java.util.HashMap;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class BountyHunterZombieHandler
extends ZombieHandler {
    public BountyHunterZombieHandler(BasicLivingExtension<Zombie> extension) {
        super(extension);
    }

    @Override
    protected ItemStack createHeldItem() {
        ItemStack gunStack = ((GunItem)ModItems.M9.get()).m_7968_();
        gunStack.getCapability(Gun.CAPABILITY).ifPresent(gun -> {
            ItemStack magazineStack = ((MagazineItem)ModItems.M9_MAGAZINE.get()).m_7968_();
            gun.setAmmoProvider((AmmoProvider)new RefillableAmmoProvider(magazineStack, 0, true));
            HashMap<GunCraftSlotType, Attachment> attachments = new HashMap<GunCraftSlotType, Attachment>();
            Attachment suppressor = (Attachment)Attachments.SUPPRESSOR.get();
            attachments.put(GunCraftSlotType.MUZZLE_ATTACHMENT, suppressor);
            gun.setAttachments(attachments);
        });
        return gunStack;
    }

    @Override
    protected ItemStack createHatItem() {
        return ((Item)ModItems.TOP_HAT.get()).m_7968_();
    }

    @Override
    protected ItemStack createClothingItem() {
        return ((Item)ModItems.BUSINESS_CLOTHING.get()).m_7968_();
    }

    @Override
    public void applyEquipmentDropChances() {
        Zombie zombie = (Zombie)this.extension.entity();
        this.extension.setEquipmentDropChance(Equipment.Slot.CLOTHING, ((Double)CraftingDeadSurvival.serverConfig.bountyHunterZombieClothingDropChance.get()).floatValue());
        this.extension.setEquipmentDropChance(Equipment.Slot.HAT, ((Double)CraftingDeadSurvival.serverConfig.bountyHunterZombieHatDropChance.get()).floatValue());
        this.extension.setEquipmentDropChance(Equipment.Slot.VEST, ((Double)CraftingDeadSurvival.serverConfig.bountyHunterZombieVestDropChance.get()).floatValue());
        this.extension.setEquipmentDropChance(Equipment.Slot.BACKPACK, ((Double)CraftingDeadSurvival.serverConfig.bountyHunterZombieBackpackDropChance.get()).floatValue());
        zombie.m_21409_(EquipmentSlot.MAINHAND, ((Double)CraftingDeadSurvival.serverConfig.bountyHunterZombieHandDropChance.get()).floatValue());
        zombie.m_21409_(EquipmentSlot.OFFHAND, ((Double)CraftingDeadSurvival.serverConfig.bountyHunterZombieHandDropChance.get()).floatValue());
    }
}

