/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.survival;

import com.craftingdead.core.event.GunEvent;
import com.craftingdead.core.event.LivingExtensionEvent;
import com.craftingdead.core.world.action.ActionTypes;
import com.craftingdead.core.world.action.item.EntityItemAction;
import com.craftingdead.core.world.action.item.EntityItemActionType;
import com.craftingdead.core.world.entity.extension.BasicLivingExtension;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.entity.extension.LivingHandler;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.item.ModItems;
import com.craftingdead.core.world.item.equipment.Equipment;
import com.craftingdead.survival.ModDist;
import com.craftingdead.survival.ServerConfig;
import com.craftingdead.survival.client.ClientDist;
import com.craftingdead.survival.data.SurvivalItemTagsProvider;
import com.craftingdead.survival.data.SurvivalRecipeProvider;
import com.craftingdead.survival.data.loot.SurvivalLootTableProvider;
import com.craftingdead.survival.data.models.SurvivalModelProvider;
import com.craftingdead.survival.particles.SurvivalParticleTypes;
import com.craftingdead.survival.server.ServerDist;
import com.craftingdead.survival.world.action.SurvivalActionTypes;
import com.craftingdead.survival.world.effect.SurvivalMobEffects;
import com.craftingdead.survival.world.entity.SurvivalEntityTypes;
import com.craftingdead.survival.world.entity.SurvivalPlayerHandler;
import com.craftingdead.survival.world.entity.extension.ALFAZombieHandler;
import com.craftingdead.survival.world.entity.extension.BountyHunterZombieHandler;
import com.craftingdead.survival.world.entity.extension.DesertRaiderZombieHandler;
import com.craftingdead.survival.world.entity.extension.DoctorZombieHandler;
import com.craftingdead.survival.world.entity.extension.FirefighterZombieHandler;
import com.craftingdead.survival.world.entity.extension.GiantZombieHandler;
import com.craftingdead.survival.world.entity.extension.HazmatZombieHandler;
import com.craftingdead.survival.world.entity.extension.JuggernautZombieHandler;
import com.craftingdead.survival.world.entity.extension.MinerZombieHandler;
import com.craftingdead.survival.world.entity.extension.NinjaZombieHandler;
import com.craftingdead.survival.world.entity.extension.PilotZombieHandler;
import com.craftingdead.survival.world.entity.extension.PoliceZombieHandler;
import com.craftingdead.survival.world.entity.extension.ScoutZombieHandler;
import com.craftingdead.survival.world.entity.extension.SniperZombieHandler;
import com.craftingdead.survival.world.entity.extension.SoldierZombieHandler;
import com.craftingdead.survival.world.entity.extension.SwatZombieHandler;
import com.craftingdead.survival.world.entity.extension.ZombieHandler;
import com.craftingdead.survival.world.entity.monster.DoctorZombieEntity;
import com.craftingdead.survival.world.entity.monster.FastZombie;
import com.craftingdead.survival.world.entity.monster.GiantZombie;
import com.craftingdead.survival.world.entity.monster.NinjaZombieEntity;
import com.craftingdead.survival.world.entity.monster.PilotZombieEntity;
import com.craftingdead.survival.world.entity.monster.PoliceZombieEntity;
import com.craftingdead.survival.world.entity.monster.ScoutZombieEntity;
import com.craftingdead.survival.world.entity.monster.SniperZombieEntity;
import com.craftingdead.survival.world.entity.monster.SoldierZombieEntity;
import com.craftingdead.survival.world.entity.monster.TankZombie;
import com.craftingdead.survival.world.entity.monster.WeakZombie;
import com.craftingdead.survival.world.item.ConsumableConfigOverrides;
import com.craftingdead.survival.world.item.SurvivalItems;
import com.craftingdead.survival.world.item.enchantment.InfectionEnchantment;
import com.craftingdead.survival.world.item.enchantment.SurvivalEnchantments;
import com.craftingdead.survival.world.level.block.SurvivalBlocks;
import com.mojang.logging.LogUtils;
import java.util.ListIterator;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.data.ForgeBlockTagsProvider;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.living.LivingPackSizeEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.JarVersionLookupHandler;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

@Mod(value="craftingdeadsurvival")
public class CraftingDeadSurvival {
    public static final String ID = "craftingdeadsurvival";
    public static final String VERSION = JarVersionLookupHandler.getImplementationVersion(CraftingDeadSurvival.class).orElse("[version]");
    private static final String H_CD_SERVER_CORE_ID = "hcdservercore";
    private static final Logger logger = LogUtils.getLogger();
    public static final ServerConfig serverConfig;
    public static final ForgeConfigSpec serverConfigSpec;
    private static CraftingDeadSurvival instance;
    private final ModDist modDist;
    private final boolean immerseLoaded = ModList.get().isLoaded("craftingdeadimmerse");

    public CraftingDeadSurvival() {
        instance = this;
        this.modDist = (ModDist)DistExecutor.unsafeRunForDist(() -> ClientDist::new, () -> ServerDist::new);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::handleCommonSetup);
        modEventBus.addListener(this::handleEntityAttributeCreation);
        modEventBus.addListener(this::handleGatherData);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)serverConfigSpec);
        MinecraftForge.EVENT_BUS.register((Object)this);
        SurvivalEnchantments.deferredRegister.register(modEventBus);
        SurvivalActionTypes.deferredRegister.register(modEventBus);
        SurvivalItems.deferredRegister.register(modEventBus);
        SurvivalMobEffects.deferredRegister.register(modEventBus);
        SurvivalEntityTypes.deferredRegister.register(modEventBus);
        SurvivalParticleTypes.deferredRegister.register(modEventBus);
        SurvivalBlocks.deferredRegister.register(modEventBus);
    }

    public ModDist getModDist() {
        return this.modDist;
    }

    public boolean isImmerseLoaded() {
        return this.immerseLoaded;
    }

    public static CraftingDeadSurvival instance() {
        return instance;
    }

    private void handleCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.SYRINGE.get()}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42436_, Items.f_42437_}), (ItemStack)new ItemStack((ItemLike)SurvivalItems.CURE_SYRINGE.get())));
        CraftingDeadSurvival.registerEntitySpawnPlacements();
    }

    private static void registerEntitySpawnPlacements() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)SurvivalEntityTypes.FAST_ZOMBIE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CraftingDeadSurvival::checkZombieSpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)SurvivalEntityTypes.TANK_ZOMBIE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CraftingDeadSurvival::checkZombieSpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)SurvivalEntityTypes.WEAK_ZOMBIE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CraftingDeadSurvival::checkZombieSpawnRules);
    }

    private void handleEntityAttributeCreation(EntityAttributeCreationEvent event) {
        event.put((EntityType)SurvivalEntityTypes.DOCTOR_ZOMBIE.get(), DoctorZombieEntity.m_34328_().m_22265_());
        event.put((EntityType)SurvivalEntityTypes.FAST_ZOMBIE.get(), FastZombie.m_34328_().m_22265_());
        event.put((EntityType)SurvivalEntityTypes.GIANT_ZOMBIE.get(), GiantZombie.m_34328_().m_22265_());
        event.put((EntityType)SurvivalEntityTypes.SCOUT_ZOMBIE.get(), ScoutZombieEntity.m_34328_().m_22265_());
        event.put((EntityType)SurvivalEntityTypes.SNIPER_ZOMBIE.get(), SniperZombieEntity.m_34328_().m_22265_());
        event.put((EntityType)SurvivalEntityTypes.PILOT_ZOMBIE.get(), PilotZombieEntity.m_34328_().m_22265_());
        event.put((EntityType)SurvivalEntityTypes.SOLDIER_ZOMBIE.get(), SoldierZombieEntity.m_34328_().m_22265_());
        event.put((EntityType)SurvivalEntityTypes.NINJA_ZOMBIE.get(), NinjaZombieEntity.m_34328_().m_22265_());
        event.put((EntityType)SurvivalEntityTypes.ALFA_ZOMBIE.get(), WeakZombie.m_34328_().m_22265_());
        event.put((EntityType)SurvivalEntityTypes.BOUNTY_HUNTER_ZOMBIE.get(), WeakZombie.m_34328_().m_22265_());
        event.put((EntityType)SurvivalEntityTypes.DESERT_RAIDER_ZOMBIE.get(), WeakZombie.m_34328_().m_22265_());
        event.put((EntityType)SurvivalEntityTypes.FIREFIGHTER_ZOMBIE.get(), WeakZombie.m_34328_().m_22265_());
        event.put((EntityType)SurvivalEntityTypes.HAZMAT_ZOMBIE.get(), WeakZombie.m_34328_().m_22265_());
        event.put((EntityType)SurvivalEntityTypes.JUGGERNAUT_ZOMBIE.get(), WeakZombie.m_34328_().m_22265_());
        event.put((EntityType)SurvivalEntityTypes.MINER_ZOMBIE.get(), WeakZombie.m_34328_().m_22265_());
        event.put((EntityType)SurvivalEntityTypes.SWAT_ZOMBIE.get(), WeakZombie.m_34328_().m_22265_());
        event.put((EntityType)SurvivalEntityTypes.POLICE_ZOMBIE.get(), PoliceZombieEntity.m_34328_().m_22265_());
        event.put((EntityType)SurvivalEntityTypes.TANK_ZOMBIE.get(), TankZombie.m_34328_().m_22265_());
        event.put((EntityType)SurvivalEntityTypes.WEAK_ZOMBIE.get(), WeakZombie.m_34328_().m_22265_());
    }

    private void handleGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        if (event.includeServer()) {
            generator.m_123914_((DataProvider)new SurvivalItemTagsProvider(generator, (BlockTagsProvider)new ForgeBlockTagsProvider(generator, event.getExistingFileHelper()), event.getExistingFileHelper()));
            generator.m_123914_((DataProvider)new SurvivalRecipeProvider(generator));
            generator.m_123914_((DataProvider)new SurvivalLootTableProvider(generator));
        }
        if (event.includeClient()) {
            generator.m_123914_((DataProvider)new SurvivalModelProvider(generator));
        }
    }

    @SubscribeEvent
    public void handleLivingPackSize(LivingPackSizeEvent event) {
        if (event.getEntity() instanceof Zombie) {
            event.setMaxPackSize(12);
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void handleServerAboutToStart(ServerAboutToStartEvent event) {
        ConsumableConfigOverrides.loadOverrides();
        logger.info("Loaded consumable configuration overrides");
    }

    @SubscribeEvent
    public void handleSpecialSpawn(LivingSpawnEvent.SpecialSpawn event) {
        Entity entity;
        Level level = event.getEntity().m_183503_();
        if (!level.m_5776_() && (entity = event.getEntity()) instanceof Zombie) {
            Zombie zombie = (Zombie)entity;
            zombie.m_21051_(Attributes.f_22282_).m_22100_(((Double)CraftingDeadSurvival.serverConfig.zombieAttackKnockback.get()).doubleValue());
            if (zombie.m_6095_() == EntityType.f_20501_) {
                zombie.m_21051_(Attributes.f_22276_).m_22100_(((Double)CraftingDeadSurvival.serverConfig.advancedZombieMaxHealth.get()).doubleValue());
                zombie.m_21051_(Attributes.f_22281_).m_22100_(((Double)CraftingDeadSurvival.serverConfig.advancedZombieAttackDamage.get()).doubleValue());
            }
            zombie.m_21051_(Attributes.f_22284_).m_22125_(new AttributeModifier("Armor bonus", 2.0, AttributeModifier.Operation.ADDITION));
            LivingExtension extension = LivingExtension.getOrThrow((LivingEntity)zombie);
            extension.getHandler(ZombieHandler.TYPE).ifPresentOrElse(ZombieHandler::applyEquipmentDropChances, () -> {
                extension.setEquipmentDropChance(Equipment.Slot.CLOTHING, ((Double)CraftingDeadSurvival.serverConfig.zombieClothingDropChance.get()).floatValue());
                extension.setEquipmentDropChance(Equipment.Slot.HAT, ((Double)CraftingDeadSurvival.serverConfig.zombieHatDropChance.get()).floatValue());
                extension.setEquipmentDropChance(Equipment.Slot.VEST, ((Double)CraftingDeadSurvival.serverConfig.zombieVestDropChance.get()).floatValue());
                extension.setEquipmentDropChance(Equipment.Slot.BACKPACK, ((Double)CraftingDeadSurvival.serverConfig.zombieBackpackDropChance.get()).floatValue());
                zombie.m_21409_(EquipmentSlot.MAINHAND, ((Double)CraftingDeadSurvival.serverConfig.zombieHandDropChance.get()).floatValue());
                zombie.m_21409_(EquipmentSlot.OFFHAND, ((Double)CraftingDeadSurvival.serverConfig.zombieHandDropChance.get()).floatValue());
            });
        }
    }

    @SubscribeEvent
    public void handlePerformAction(LivingExtensionEvent.PerformAction<EntityItemAction<?>> event) {
        EntityItemAction action = (EntityItemAction)event.getAction();
        LivingExtension target = action.getSelectedTarget();
        if (!event.getLiving().level().m_5776_() && action.type() == ActionTypes.USE_SYRINGE.get()) {
            ((EntityItemActionType)SurvivalActionTypes.USE_SYRINGE_ON_ZOMBIE.get()).createEntityAction(event.getLiving(), target, action.getHand()).ifPresent(newAction -> {
                event.setCanceled(true);
                event.getLiving().performAction(newAction, true);
            });
        }
    }

    @SubscribeEvent
    public void handleMissingBlockMappings(RegistryEvent.MissingMappings<Block> event) {
        event.getMappings(H_CD_SERVER_CORE_ID).forEach(mapping -> {
            Block newBlock = (Block)mapping.registry.getValue(new ResourceLocation(ID, mapping.key.m_135815_()));
            if (newBlock != null) {
                mapping.remap((IForgeRegistryEntry)newBlock);
            }
        });
    }

    @SubscribeEvent
    public void handleMissingItemMappings(RegistryEvent.MissingMappings<Item> event) {
        event.getMappings(H_CD_SERVER_CORE_ID).forEach(mapping -> {
            Item newItem = (Item)mapping.registry.getValue(new ResourceLocation(ID, mapping.key.m_135815_()));
            if (newItem != null) {
                mapping.remap((IForgeRegistryEntry)newItem);
            }
        });
    }

    @SubscribeEvent
    public void handleAttachLivingExtensions(LivingExtensionEvent.Load event) {
        LivingExtension livingExtension = event.getLiving();
        if (livingExtension instanceof PlayerExtension) {
            PlayerExtension player = (PlayerExtension)livingExtension;
            player.registerHandler(SurvivalPlayerHandler.TYPE, (LivingHandler)new SurvivalPlayerHandler(player));
        } else {
            livingExtension = event.getLiving().entity();
            if (livingExtension instanceof Zombie) {
                Zombie zombie = (Zombie)livingExtension;
                BasicLivingExtension extension = (BasicLivingExtension)event.getLiving();
                ZombieHandler handler = zombie.m_6095_() == SurvivalEntityTypes.DOCTOR_ZOMBIE.get() ? new DoctorZombieHandler((BasicLivingExtension<Zombie>)extension) : (zombie.m_6095_() == SurvivalEntityTypes.GIANT_ZOMBIE.get() ? new GiantZombieHandler((BasicLivingExtension<Zombie>)extension) : (zombie.m_6095_() == SurvivalEntityTypes.POLICE_ZOMBIE.get() ? new PoliceZombieHandler((BasicLivingExtension<Zombie>)extension) : (zombie.m_6095_() == SurvivalEntityTypes.SCOUT_ZOMBIE.get() ? new ScoutZombieHandler((BasicLivingExtension<Zombie>)extension) : (zombie.m_6095_() == SurvivalEntityTypes.SNIPER_ZOMBIE.get() ? new SniperZombieHandler((BasicLivingExtension<Zombie>)extension) : (zombie.m_6095_() == SurvivalEntityTypes.PILOT_ZOMBIE.get() ? new PilotZombieHandler((BasicLivingExtension<Zombie>)extension) : (zombie.m_6095_() == SurvivalEntityTypes.SOLDIER_ZOMBIE.get() ? new SoldierZombieHandler((BasicLivingExtension<Zombie>)extension) : (zombie.m_6095_() == SurvivalEntityTypes.NINJA_ZOMBIE.get() ? new NinjaZombieHandler((BasicLivingExtension<Zombie>)extension) : (zombie.m_6095_() == SurvivalEntityTypes.ALFA_ZOMBIE.get() ? new ALFAZombieHandler((BasicLivingExtension<Zombie>)extension) : (zombie.m_6095_() == SurvivalEntityTypes.BOUNTY_HUNTER_ZOMBIE.get() ? new BountyHunterZombieHandler((BasicLivingExtension<Zombie>)extension) : (zombie.m_6095_() == SurvivalEntityTypes.DESERT_RAIDER_ZOMBIE.get() ? new DesertRaiderZombieHandler((BasicLivingExtension<Zombie>)extension) : (zombie.m_6095_() == SurvivalEntityTypes.FIREFIGHTER_ZOMBIE.get() ? new FirefighterZombieHandler((BasicLivingExtension<Zombie>)extension) : (zombie.m_6095_() == SurvivalEntityTypes.HAZMAT_ZOMBIE.get() ? new HazmatZombieHandler((BasicLivingExtension<Zombie>)extension) : (zombie.m_6095_() == SurvivalEntityTypes.JUGGERNAUT_ZOMBIE.get() ? new JuggernautZombieHandler((BasicLivingExtension<Zombie>)extension) : (zombie.m_6095_() == SurvivalEntityTypes.MINER_ZOMBIE.get() ? new MinerZombieHandler((BasicLivingExtension<Zombie>)extension) : (zombie.m_6095_() == SurvivalEntityTypes.SWAT_ZOMBIE.get() ? new SwatZombieHandler((BasicLivingExtension<Zombie>)extension) : new ZombieHandler((BasicLivingExtension<Zombie>)extension))))))))))))))));
                extension.registerHandler(ZombieHandler.TYPE, (LivingHandler)handler);
            }
        }
    }

    @SubscribeEvent
    public void handleGunHitEntity(GunEvent.EntityHit event) {
        event.target().getCapability(LivingExtension.CAPABILITY).resolve().flatMap(living -> living.getHandler(SurvivalPlayerHandler.TYPE)).ifPresent(playerHandler -> {
            float enchantmentPct = (float)EnchantmentHelper.m_44843_((Enchantment)((Enchantment)SurvivalEnchantments.INFECTION.get()), (ItemStack)event.getItemStack()) / (float)((InfectionEnchantment)((Object)((Object)SurvivalEnchantments.INFECTION.get()))).m_6586_();
            playerHandler.infect(enchantmentPct);
        });
    }

    @SubscribeEvent
    public void handleBiomeLoading(BiomeLoadingEvent event) {
        if (!((Boolean)CraftingDeadSurvival.serverConfig.zombiesEnabled.get()).booleanValue()) {
            return;
        }
        ListIterator<MobSpawnSettings.SpawnerData> iterator = event.getSpawns().getSpawner(MobCategory.MONSTER).listIterator();
        while (iterator.hasNext()) {
            int weight;
            MobSpawnSettings.SpawnerData spawnEntry = (MobSpawnSettings.SpawnerData)iterator.next();
            if (spawnEntry.f_48404_ != EntityType.f_20501_) continue;
            iterator.remove();
            if (((Boolean)CraftingDeadSurvival.serverConfig.advancedZombiesEnabled.get()).booleanValue()) {
                weight = this.applySpawnMultipliers((Integer)CraftingDeadSurvival.serverConfig.advancedZombieSpawnWeight.get(), (Double)CraftingDeadSurvival.serverConfig.civilianZombieSpawnMultiplier.get());
                iterator.add(new MobSpawnSettings.SpawnerData(EntityType.f_20501_, weight, ((Integer)CraftingDeadSurvival.serverConfig.advancedZombieMinSpawn.get()).intValue(), ((Integer)CraftingDeadSurvival.serverConfig.advancedZombieMaxSpawn.get()).intValue()));
            }
            if (((Boolean)CraftingDeadSurvival.serverConfig.fastZombiesEnabled.get()).booleanValue()) {
                weight = this.applySpawnMultipliers((Integer)CraftingDeadSurvival.serverConfig.fastZombieSpawnWeight.get(), (Double)CraftingDeadSurvival.serverConfig.civilianZombieSpawnMultiplier.get());
                iterator.add(new MobSpawnSettings.SpawnerData((EntityType)SurvivalEntityTypes.FAST_ZOMBIE.get(), weight, ((Integer)CraftingDeadSurvival.serverConfig.fastZombieMinSpawn.get()).intValue(), ((Integer)CraftingDeadSurvival.serverConfig.fastZombieMaxSpawn.get()).intValue()));
            }
            if (((Boolean)CraftingDeadSurvival.serverConfig.tankZombiesEnabled.get()).booleanValue()) {
                weight = this.applySpawnMultipliers((Integer)CraftingDeadSurvival.serverConfig.tankZombieSpawnWeight.get(), (Double)CraftingDeadSurvival.serverConfig.civilianZombieSpawnMultiplier.get());
                iterator.add(new MobSpawnSettings.SpawnerData((EntityType)SurvivalEntityTypes.TANK_ZOMBIE.get(), weight, ((Integer)CraftingDeadSurvival.serverConfig.tankZombieMinSpawn.get()).intValue(), ((Integer)CraftingDeadSurvival.serverConfig.tankZombieMaxSpawn.get()).intValue()));
            }
            if (!((Boolean)CraftingDeadSurvival.serverConfig.weakZombiesEnabled.get()).booleanValue()) continue;
            weight = this.applySpawnMultipliers((Integer)CraftingDeadSurvival.serverConfig.weakZombieSpawnWeight.get(), (Double)CraftingDeadSurvival.serverConfig.civilianZombieSpawnMultiplier.get());
            iterator.add(new MobSpawnSettings.SpawnerData((EntityType)SurvivalEntityTypes.WEAK_ZOMBIE.get(), weight, ((Integer)CraftingDeadSurvival.serverConfig.weakZombieMinSpawn.get()).intValue(), ((Integer)CraftingDeadSurvival.serverConfig.weakZombieMaxSpawn.get()).intValue()));
        }
    }

    private int applySpawnMultipliers(int baseWeight, double categoryMultiplier) {
        double globalMult = (Double)CraftingDeadSurvival.serverConfig.globalZombieSpawnMultiplier.get();
        double weight = (double)baseWeight * globalMult * categoryMultiplier;
        return Math.max(1, (int)Math.round(weight));
    }

    public static boolean checkZombieSpawnRules(EntityType<? extends Monster> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, Random random) {
        return level.m_45517_(LightLayer.BLOCK, pos) <= 8 && Monster.m_33023_(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (Random)random);
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        serverConfigSpec = (ForgeConfigSpec)pair.getRight();
        serverConfig = (ServerConfig)pair.getLeft();
    }
}

