/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.survival.world.entity.extension;

import com.craftingdead.core.world.entity.extension.BasicLivingExtension;
import com.craftingdead.core.world.entity.extension.LivingHandler;
import com.craftingdead.core.world.entity.extension.LivingHandlerType;
import com.craftingdead.core.world.item.equipment.Equipment;
import com.craftingdead.core.world.item.gun.Gun;
import com.craftingdead.core.world.item.gun.ammoprovider.AmmoProvider;
import com.craftingdead.core.world.item.gun.ammoprovider.MagazineAmmoProvider;
import com.craftingdead.survival.CraftingDeadSurvival;
import com.craftingdead.survival.tags.SurvivalItemTags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.items.CapabilityItemHandler;

public class ZombieHandler
implements LivingHandler {
    public static final LivingHandlerType<ZombieHandler> TYPE = new LivingHandlerType(new ResourceLocation("craftingdeadsurvival", "zombie"));
    private static final UUID HEALTH_MODIFIER_BABY_UUID = UUID.fromString("69d754ea-1ae3-4684-bb69-51a29de92b9a");
    private static final AttributeModifier HEALTH_MODIFIER_BABY = new AttributeModifier(HEALTH_MODIFIER_BABY_UUID, "Baby health reduction", -1.5, AttributeModifier.Operation.MULTIPLY_BASE);
    protected final BasicLivingExtension<Zombie> extension;
    private int textureIndex;

    public ZombieHandler(BasicLivingExtension<Zombie> extension) {
        this.extension = extension;
        this.textureIndex = extension.random().nextInt(23);
    }

    public int getTextureIndex() {
        return this.textureIndex;
    }

    public void handleSetBaby(boolean baby) {
        if (this.extension.level().m_5776_()) {
            return;
        }
        Zombie zombie = (Zombie)this.extension.entity();
        if (zombie.m_20202_() instanceof Chicken) {
            zombie.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        AttributeInstance healthAttribute = zombie.m_21051_(Attributes.f_22276_);
        healthAttribute.m_22130_(HEALTH_MODIFIER_BABY);
        if (baby) {
            healthAttribute.m_22118_(HEALTH_MODIFIER_BABY);
        }
    }

    public void populateDefaultEquipmentSlots(DifficultyInstance difficulty) {
        Zombie zombie = (Zombie)this.extension.entity();
        zombie.m_8061_(EquipmentSlot.MAINHAND, this.createHeldItem());
        this.extension.setItemInSlot(Equipment.Slot.CLOTHING, this.createClothingItem());
        this.extension.setItemInSlot(Equipment.Slot.HAT, this.createHatItem());
        this.extension.setItemInSlot(Equipment.Slot.BACKPACK, this.createBackpackItem());
        this.extension.setItemInSlot(Equipment.Slot.VEST, this.createVestItem());
    }

    protected ItemStack createHeldItem() {
        return this.getRandomItem(SurvivalItemTags.ZOMBIE_HAND_LOOT, ((Double)CraftingDeadSurvival.serverConfig.zombieHandSpawnChance.get()).floatValue()).map(Item::m_7968_).orElse(ItemStack.f_41583_);
    }

    protected ItemStack createHatItem() {
        return this.getRandomItem(SurvivalItemTags.ZOMBIE_HAT_LOOT, ((Double)CraftingDeadSurvival.serverConfig.zombieHatSpawnChance.get()).floatValue()).map(Item::m_7968_).orElse(ItemStack.f_41583_);
    }

    protected ItemStack createClothingItem() {
        return this.getRandomItem(SurvivalItemTags.ZOMBIE_CLOTHING_LOOT, ((Double)CraftingDeadSurvival.serverConfig.zombieClothingSpawnChance.get()).floatValue()).map(Item::m_7968_).orElse(ItemStack.f_41583_);
    }

    protected ItemStack createBackpackItem() {
        return this.getRandomItem(SurvivalItemTags.ZOMBIE_BACKPACK_LOOT, 1.0f).map(Item::m_7968_).orElse(ItemStack.f_41583_);
    }

    protected ItemStack createVestItem() {
        return this.getRandomItem(SurvivalItemTags.ZOMBIE_VEST_LOOT, 1.0f).map(Item::m_7968_).orElse(ItemStack.f_41583_);
    }

    protected Optional<Item> getRandomItem(TagKey<Item> tagKey, float probability) {
        Random random = this.extension.random();
        return random.nextFloat() < probability ? Registry.f_122827_.m_203431_(tagKey).flatMap(tag -> tag.m_203450_(random)).map(Holder::m_203334_) : Optional.empty();
    }

    protected ItemStack getRandomItem(List<Item> items) {
        if (items == null || items.isEmpty()) {
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)items.get(this.extension.random().nextInt(items.size())));
    }

    protected ItemStack createFilledVestItem(float equipChance, ItemStack vestStack, ResourceLocation location) {
        if (this.extension.random().nextFloat() >= equipChance) {
            return ItemStack.f_41583_;
        }
        ServerLevel level = (ServerLevel)this.extension.level();
        LootTable lootTable = level.m_142572_().m_129898_().m_79217_(location);
        if (lootTable == LootTable.f_79105_) {
            return vestStack;
        }
        LootContext.Builder builder = new LootContext.Builder(level).m_78972_(LootContextParams.f_81460_, (Object)((Zombie)this.extension.entity()).m_20182_());
        LootContext context = builder.m_78975_(LootContextParamSets.f_81411_);
        List loot = lootTable.m_79129_(context);
        vestStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> {
            int i;
            ArrayList<Integer> slots = new ArrayList<Integer>();
            for (i = 0; i < inv.getSlots(); ++i) {
                slots.add(i);
            }
            Collections.shuffle(slots, this.extension.random());
            for (i = 0; i < loot.size() && i < slots.size(); ++i) {
                inv.insertItem(((Integer)slots.get(i)).intValue(), (ItemStack)loot.get(i), false);
            }
        });
        return vestStack;
    }

    protected ItemStack createFilledBackpackItem(float equipChance, ItemStack backpackStack, ResourceLocation location) {
        if (this.extension.random().nextFloat() >= equipChance) {
            return ItemStack.f_41583_;
        }
        ServerLevel level = (ServerLevel)this.extension.level();
        LootTable lootTable = level.m_142572_().m_129898_().m_79217_(location);
        if (lootTable == LootTable.f_79105_) {
            return backpackStack;
        }
        LootContext.Builder builder = new LootContext.Builder(level).m_78972_(LootContextParams.f_81460_, (Object)((Zombie)this.extension.entity()).m_20182_());
        LootContext context = builder.m_78975_(LootContextParamSets.f_81411_);
        List loot = lootTable.m_79129_(context);
        backpackStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> {
            int i;
            ArrayList<Integer> slots = new ArrayList<Integer>();
            for (i = 0; i < inv.getSlots(); ++i) {
                slots.add(i);
            }
            Collections.shuffle(slots, this.extension.random());
            for (i = 0; i < loot.size() && i < slots.size(); ++i) {
                inv.insertItem(((Integer)slots.get(i)).intValue(), (ItemStack)loot.get(i), false);
            }
        });
        return backpackStack;
    }

    public void applyEquipmentDropChances() {
        Zombie zombie = (Zombie)this.extension.entity();
        this.extension.setEquipmentDropChance(Equipment.Slot.CLOTHING, ((Double)CraftingDeadSurvival.serverConfig.zombieClothingDropChance.get()).floatValue());
        this.extension.setEquipmentDropChance(Equipment.Slot.HAT, ((Double)CraftingDeadSurvival.serverConfig.zombieHatDropChance.get()).floatValue());
        this.extension.setEquipmentDropChance(Equipment.Slot.VEST, ((Double)CraftingDeadSurvival.serverConfig.zombieVestDropChance.get()).floatValue());
        this.extension.setEquipmentDropChance(Equipment.Slot.BACKPACK, ((Double)CraftingDeadSurvival.serverConfig.zombieBackpackDropChance.get()).floatValue());
        zombie.m_21409_(EquipmentSlot.MAINHAND, ((Double)CraftingDeadSurvival.serverConfig.zombieHandDropChance.get()).floatValue());
        zombie.m_21409_(EquipmentSlot.OFFHAND, ((Double)CraftingDeadSurvival.serverConfig.zombieHandDropChance.get()).floatValue());
    }

    protected ResourceLocation createVestLootId(String id) {
        return new ResourceLocation("craftingdeadsurvival", "vests/" + id);
    }

    protected ResourceLocation createBackpackLootId(String id) {
        return new ResourceLocation("craftingdeadsurvival", "backpacks/" + id);
    }

    public boolean handleDeathLoot(DamageSource cause, Collection<ItemEntity> loot, int lootingLevel) {
        loot.stream().map(ItemEntity::m_32055_).forEach(item -> item.getCapability(Gun.CAPABILITY).ifPresent(gun -> gun.setAmmoProvider((AmmoProvider)new MagazineAmmoProvider(gun.getDefaultMagazineStack()))));
        return false;
    }

    public void encode(FriendlyByteBuf out, boolean writeAll) {
        out.m_130130_(this.textureIndex);
    }

    public void decode(FriendlyByteBuf in) {
        this.textureIndex = in.m_130242_();
    }

    public boolean requiresSync() {
        return false;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("textureIndex", this.textureIndex);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.textureIndex = tag.m_128451_("textureIndex");
    }
}

