/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.survival.world.entity;

import com.craftingdead.survival.CraftingDeadSurvival;
import com.craftingdead.survival.world.entity.SurvivalEntityTypes;
import java.util.Comparator;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.Nullable;

public class SupplyDrop
extends Entity
implements MenuProvider {
    private static final TicketType<ChunkPos> SUPPLY_DROP_TICKET = TicketType.m_9462_((String)"supply_drop", Comparator.comparingLong(ChunkPos::m_45588_));
    private SimpleContainer container = new SimpleContainer(54);
    private int ticks = 0;
    public boolean dropActive = false;
    private boolean chunkLoaded = false;
    @Nullable
    private ResourceLocation lootTable;
    private long lootTableSeed;

    public SupplyDrop(EntityType<?> entityType, Level world) {
        super(entityType, world);
    }

    public SupplyDrop(EntityType<?> entityType, Level world, ResourceLocation lootTable, long lootTableSeed, double x, double y, double z) {
        this(entityType, world);
        this.lootTable = lootTable;
        this.lootTableSeed = lootTableSeed;
        this.m_6034_(x, y, z);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    public SupplyDrop(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType)SurvivalEntityTypes.SUPPLY_DROP.get(), world);
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        Level level;
        super.m_6075_();
        if (!this.f_19853_.m_5776_() && !this.chunkLoaded && (level = this.f_19853_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ChunkPos chunkPos = new ChunkPos(this.m_142538_());
            serverLevel.m_7726_().m_8387_(SUPPLY_DROP_TICKET, chunkPos, 1, (Object)chunkPos);
            this.chunkLoaded = true;
        }
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.0025, 0.0));
        }
        if (this.f_19861_) {
            this.m_20256_(this.m_20184_().m_82490_(0.5));
            this.dropActive = true;
            ++this.ticks;
            if (this.ticks >= (Integer)CraftingDeadSurvival.serverConfig.supplyDropDuration.get() * 20) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
        } else {
            this.ticks = 0;
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (!this.f_19853_.m_5776_() && reason.m_146965_()) {
            Containers.m_18998_((Level)this.f_19853_, (Entity)this, (Container)this.container);
        }
        if (!this.f_19853_.m_5776_() && this.chunkLoaded) {
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ChunkPos chunkPos = new ChunkPos(this.m_142538_());
                serverLevel.m_7726_().m_8438_(SUPPLY_DROP_TICKET, chunkPos, 1, (Object)chunkPos);
            }
            this.chunkLoaded = false;
        }
        super.m_142687_(reason);
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128425_("lootTable", 8)) {
            this.lootTable = new ResourceLocation(compound.m_128461_("lootTable"));
            this.lootTableSeed = compound.m_128454_("lootTableSeed");
        } else {
            NonNullList items = NonNullList.m_122780_((int)this.container.m_6643_(), (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)compound, (NonNullList)items);
            this.container = new SimpleContainer((ItemStack[])items.toArray((Object[])new ItemStack[0]));
        }
    }

    protected void m_7380_(CompoundTag compound) {
        if (this.lootTable != null) {
            compound.m_128359_("lootTable", this.lootTable.toString());
            if (this.lootTableSeed != 0L) {
                compound.m_128356_("lootTableSeed", this.lootTableSeed);
            }
        } else {
            NonNullList items = NonNullList.m_122780_((int)this.container.m_6643_(), (Object)ItemStack.f_41583_);
            for (int i = 0; i < this.container.m_6643_(); ++i) {
                items.set(i, (Object)this.container.m_8020_(i));
            }
            ContainerHelper.m_18973_((CompoundTag)compound, (NonNullList)items);
        }
    }

    public boolean m_6087_() {
        return true;
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        player.m_5893_((MenuProvider)this);
        return InteractionResult.PASS;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!((Boolean)CraftingDeadSurvival.serverConfig.allowSupplyDropBreak.get()).booleanValue()) {
            return false;
        }
        if (this.f_19853_.m_5776_() || this.m_146910_()) {
            return true;
        }
        if (this.m_6673_(source)) {
            return false;
        }
        this.m_6074_();
        return true;
    }

    private void unpackLootTable(ServerPlayer player) {
        if (this.lootTable == null) {
            return;
        }
        LootTable lootTable = this.f_19853_.m_142572_().m_129898_().m_79217_(this.lootTable);
        CriteriaTriggers.f_10563_.m_54597_(player, this.lootTable);
        this.lootTable = null;
        LootContext.Builder builder = new LootContext.Builder(player.m_183503_()).m_78972_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_78965_(this.lootTableSeed);
        builder.m_78972_(LootContextParams.f_81458_, (Object)this);
        if (player != null) {
            builder.m_78963_(player.m_36336_()).m_78972_(LootContextParams.f_81455_, (Object)player);
        }
        lootTable.m_79123_((Container)this.container, builder.m_78975_(LootContextParamSets.f_81411_));
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        if (this.lootTable != null && player.m_5833_()) {
            return null;
        }
        this.unpackLootTable((ServerPlayer)player);
        return ChestMenu.m_39246_((int)id, (Inventory)inventory, (Container)this.container);
    }
}

