/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.survival.world.entity.grenade;

import com.craftingdead.core.particle.FlashParticleOptions;
import com.craftingdead.core.world.entity.ExplosionSource;
import com.craftingdead.core.world.entity.grenade.Grenade;
import com.craftingdead.core.world.item.GrenadeItem;
import com.craftingdead.survival.CraftingDeadSurvival;
import com.craftingdead.survival.world.entity.SurvivalEntityTypes;
import com.craftingdead.survival.world.item.SurvivalItems;
import java.util.OptionalInt;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;

public class PipeBomb
extends Grenade
implements ExplosionSource {
    private static final FlashParticleOptions RED_FLASH = new FlashParticleOptions(1.0f, 0.35f, 0.35f, 1.0f);

    public PipeBomb(EntityType<? extends Grenade> type, Level level) {
        super(type, level);
    }

    public PipeBomb(Level level) {
        super((EntityType)SurvivalEntityTypes.PIPE_BOMB.get(), level);
    }

    public PipeBomb(LivingEntity thrower, Level level) {
        super((EntityType)SurvivalEntityTypes.PIPE_BOMB.get(), thrower, level);
    }

    public OptionalInt getMinimumTicksUntilAutoActivation() {
        return OptionalInt.of((Integer)CraftingDeadSurvival.serverConfig.pipeBombTicksBeforeActivation.get());
    }

    public void activatedChanged(boolean activated) {
        if (activated && !this.f_19853_.m_5776_()) {
            this.m_6074_();
            this.f_19853_.m_7703_((Entity)this, this.createDamageSource(), null, this.m_20185_(), this.m_20186_() + (double)this.m_20206_(), this.m_20189_(), ((Double)CraftingDeadSurvival.serverConfig.pipeBombRadius.get()).floatValue(), false, (Explosion.BlockInteraction)CraftingDeadSurvival.serverConfig.pipeBombBlockInteraction.get());
        }
    }

    public void onGrenadeTick() {
        if (this.f_19797_ % 6 == 0) {
            if (this.f_19853_.m_5776_()) {
                this.f_19853_.m_6493_((ParticleOptions)RED_FLASH, true, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            } else {
                this.getMinimumTicksUntilAutoActivation().ifPresent(ticks -> {
                    float pitchProgress = (float)this.f_19797_ / (float)ticks;
                    float gradualPitch = Mth.m_14179_((float)pitchProgress, (float)1.0f, (float)2.0f);
                    this.m_5496_(SoundEvents.f_12210_, 1.7f, gradualPitch);
                });
            }
        }
    }

    public boolean isAttracting() {
        return true;
    }

    public GrenadeItem asItem() {
        return (GrenadeItem)SurvivalItems.PIPE_BOMB.get();
    }

    public void onMotionStop(int stopsCount) {
    }

    public float getDamageMultiplier() {
        return ((Double)CraftingDeadSurvival.serverConfig.pipeBombDamageMultiplier.get()).floatValue();
    }

    public double getKnockbackMultiplier() {
        return (Double)CraftingDeadSurvival.serverConfig.pipeBombKnockbackMultiplier.get();
    }
}

