/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.survival.world.entity.extension;

import com.craftingdead.core.world.entity.extension.BasicLivingExtension;
import com.craftingdead.core.world.inventory.GunCraftSlotType;
import com.craftingdead.core.world.item.GunItem;
import com.craftingdead.core.world.item.MagazineItem;
import com.craftingdead.core.world.item.ModItems;
import com.craftingdead.core.world.item.equipment.Equipment;
import com.craftingdead.core.world.item.gun.Gun;
import com.craftingdead.core.world.item.gun.ammoprovider.AmmoProvider;
import com.craftingdead.core.world.item.gun.ammoprovider.RefillableAmmoProvider;
import com.craftingdead.core.world.item.gun.attachment.Attachment;
import com.craftingdead.core.world.item.gun.attachment.Attachments;
import com.craftingdead.survival.CraftingDeadSurvival;
import com.craftingdead.survival.world.entity.extension.ZombieHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.RegistryObject;

public class SniperZombieHandler
extends ZombieHandler {
    public SniperZombieHandler(BasicLivingExtension<Zombie> extension) {
        super(extension);
    }

    @Override
    protected ItemStack createHeldItem() {
        Random random = new Random();
        ItemStack gunStack = ((GunItem)ModItems.DMR.get()).m_7968_();
        gunStack.getCapability(Gun.CAPABILITY).ifPresent(gun -> {
            ItemStack magazineStack = ((MagazineItem)ModItems.DMR_MAGAZINE.get()).m_7968_();
            gun.setAmmoProvider((AmmoProvider)new RefillableAmmoProvider(magazineStack, 1, false));
            Map<GunCraftSlotType, RegistryObject> possibleAttachments = Map.of(GunCraftSlotType.OVERBARREL_ATTACHMENT, Attachments.HP_SCOPE, GunCraftSlotType.UNDERBARREL_ATTACHMENT, Attachments.BIPOD, GunCraftSlotType.MUZZLE_ATTACHMENT, Attachments.SUPPRESSOR);
            HashMap<GunCraftSlotType, Attachment> attachments = new HashMap<GunCraftSlotType, Attachment>();
            for (Map.Entry<GunCraftSlotType, RegistryObject> entry : possibleAttachments.entrySet()) {
                if (!random.nextBoolean()) continue;
                attachments.put(entry.getKey(), (Attachment)((Supplier)entry.getValue()).get());
            }
            gun.setAttachments(attachments);
        });
        return gunStack;
    }

    @Override
    protected ItemStack createClothingItem() {
        return ((Item)ModItems.TAC_GHILLIE_CLOTHING.get()).m_7968_();
    }

    @Override
    protected ItemStack createHatItem() {
        return ((Item)ModItems.GHILLIE_HAT.get()).m_7968_();
    }

    @Override
    protected ItemStack createVestItem() {
        return this.createFilledVestItem(((Double)CraftingDeadSurvival.serverConfig.sniperZombieVestEquipChance.get()).floatValue(), ((Item)ModItems.GHILLIE_TACTICAL_VEST.get()).m_7968_(), this.createVestLootId("sniper_zombie_vest_loot"));
    }

    @Override
    public void applyEquipmentDropChances() {
        Zombie zombie = (Zombie)this.extension.entity();
        this.extension.setEquipmentDropChance(Equipment.Slot.CLOTHING, ((Double)CraftingDeadSurvival.serverConfig.sniperZombieClothingDropChance.get()).floatValue());
        this.extension.setEquipmentDropChance(Equipment.Slot.HAT, ((Double)CraftingDeadSurvival.serverConfig.sniperZombieHatDropChance.get()).floatValue());
        this.extension.setEquipmentDropChance(Equipment.Slot.VEST, ((Double)CraftingDeadSurvival.serverConfig.sniperZombieVestDropChance.get()).floatValue());
        this.extension.setEquipmentDropChance(Equipment.Slot.BACKPACK, ((Double)CraftingDeadSurvival.serverConfig.sniperZombieBackpackDropChance.get()).floatValue());
        zombie.m_21409_(EquipmentSlot.MAINHAND, ((Double)CraftingDeadSurvival.serverConfig.sniperZombieHandDropChance.get()).floatValue());
        zombie.m_21409_(EquipmentSlot.OFFHAND, ((Double)CraftingDeadSurvival.serverConfig.sniperZombieHandDropChance.get()).floatValue());
    }
}

