/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.survival.world.entity.extension;

import com.craftingdead.core.world.entity.extension.BasicLivingExtension;
import com.craftingdead.core.world.inventory.GunCraftSlotType;
import com.craftingdead.core.world.item.GunItem;
import com.craftingdead.core.world.item.MagazineItem;
import com.craftingdead.core.world.item.ModItems;
import com.craftingdead.core.world.item.equipment.Equipment;
import com.craftingdead.core.world.item.gun.Gun;
import com.craftingdead.core.world.item.gun.ammoprovider.AmmoProvider;
import com.craftingdead.core.world.item.gun.ammoprovider.RefillableAmmoProvider;
import com.craftingdead.core.world.item.gun.attachment.Attachment;
import com.craftingdead.core.world.item.gun.attachment.Attachments;
import com.craftingdead.survival.CraftingDeadSurvival;
import com.craftingdead.survival.world.entity.extension.ZombieHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.RegistryObject;

public class JuggernautZombieHandler
extends ZombieHandler {
    public JuggernautZombieHandler(BasicLivingExtension<Zombie> extension) {
        super(extension);
    }

    @Override
    protected ItemStack createHeldItem() {
        Random random = new Random();
        ItemStack gunStack = ((GunItem)ModItems.M240B.get()).m_7968_();
        gunStack.getCapability(Gun.CAPABILITY).ifPresent(gun -> {
            ItemStack magazineStack = ((MagazineItem)ModItems.M240B_MAGAZINE.get()).m_7968_();
            gun.setAmmoProvider((AmmoProvider)new RefillableAmmoProvider(magazineStack, 0, true));
            Map<GunCraftSlotType, RegistryObject> possibleAttachments = Map.of(GunCraftSlotType.OVERBARREL_ATTACHMENT, Attachments.RED_DOT_SIGHT, GunCraftSlotType.UNDERBARREL_ATTACHMENT, Attachments.TACTICAL_GRIP, GunCraftSlotType.MUZZLE_ATTACHMENT, Attachments.SUPPRESSOR);
            HashMap<GunCraftSlotType, Attachment> attachments = new HashMap<GunCraftSlotType, Attachment>();
            for (Map.Entry<GunCraftSlotType, RegistryObject> entry : possibleAttachments.entrySet()) {
                if (!random.nextBoolean()) continue;
                attachments.put(entry.getKey(), (Attachment)((Supplier)entry.getValue()).get());
            }
            gun.setAttachments(attachments);
        });
        return gunStack;
    }

    @Override
    protected ItemStack createHatItem() {
        return ((Item)ModItems.BLACK_BALLISTIC_HAT.get()).m_7968_();
    }

    @Override
    protected ItemStack createClothingItem() {
        return ((Item)ModItems.JUGGERNAUT_CLOTHING.get()).m_7968_();
    }

    @Override
    protected ItemStack createVestItem() {
        return this.createFilledVestItem(((Double)CraftingDeadSurvival.serverConfig.juggernautZombieVestEquipChance.get()).floatValue(), ((Item)ModItems.RIOT_VEST.get()).m_7968_(), this.createVestLootId("juggernaut_zombie_vest_loot"));
    }

    @Override
    public void applyEquipmentDropChances() {
        Zombie zombie = (Zombie)this.extension.entity();
        this.extension.setEquipmentDropChance(Equipment.Slot.CLOTHING, ((Double)CraftingDeadSurvival.serverConfig.juggernautZombieClothingDropChance.get()).floatValue());
        this.extension.setEquipmentDropChance(Equipment.Slot.HAT, ((Double)CraftingDeadSurvival.serverConfig.juggernautZombieHatDropChance.get()).floatValue());
        this.extension.setEquipmentDropChance(Equipment.Slot.VEST, ((Double)CraftingDeadSurvival.serverConfig.juggernautZombieVestDropChance.get()).floatValue());
        this.extension.setEquipmentDropChance(Equipment.Slot.BACKPACK, ((Double)CraftingDeadSurvival.serverConfig.juggernautZombieBackpackDropChance.get()).floatValue());
        zombie.m_21409_(EquipmentSlot.MAINHAND, ((Double)CraftingDeadSurvival.serverConfig.juggernautZombieHandDropChance.get()).floatValue());
        zombie.m_21409_(EquipmentSlot.OFFHAND, ((Double)CraftingDeadSurvival.serverConfig.juggernautZombieHandDropChance.get()).floatValue());
    }
}

