/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.survival.world.entity.extension;

import com.craftingdead.core.world.entity.extension.BasicLivingExtension;
import com.craftingdead.core.world.inventory.GunCraftSlotType;
import com.craftingdead.core.world.item.GunItem;
import com.craftingdead.core.world.item.MagazineItem;
import com.craftingdead.core.world.item.ModItems;
import com.craftingdead.core.world.item.equipment.Equipment;
import com.craftingdead.core.world.item.gun.Gun;
import com.craftingdead.core.world.item.gun.ammoprovider.AmmoProvider;
import com.craftingdead.core.world.item.gun.ammoprovider.RefillableAmmoProvider;
import com.craftingdead.core.world.item.gun.attachment.Attachment;
import com.craftingdead.core.world.item.gun.attachment.Attachments;
import com.craftingdead.survival.CraftingDeadSurvival;
import com.craftingdead.survival.world.entity.extension.ZombieHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.RegistryObject;

public class SoldierZombieHandler
extends ZombieHandler {
    public SoldierZombieHandler(BasicLivingExtension<Zombie> extension) {
        super(extension);
    }

    @Override
    protected ItemStack createHeldItem() {
        Random random = new Random();
        ItemStack gunStack = ((GunItem)ModItems.SCARL.get()).m_7968_().m_41777_();
        gunStack.getCapability(Gun.CAPABILITY).ifPresent(gun -> {
            ItemStack magazineStack = ((MagazineItem)ModItems.STANAG_30_ROUND_MAGAZINE.get()).m_7968_();
            gun.setAmmoProvider((AmmoProvider)new RefillableAmmoProvider(magazineStack, 2, false));
            Map<GunCraftSlotType, RegistryObject> possibleAttachments = Map.of(GunCraftSlotType.OVERBARREL_ATTACHMENT, Attachments.RED_DOT_SIGHT, GunCraftSlotType.UNDERBARREL_ATTACHMENT, Attachments.TACTICAL_GRIP, GunCraftSlotType.MUZZLE_ATTACHMENT, Attachments.SUPPRESSOR);
            HashMap<GunCraftSlotType, Attachment> attachments = new HashMap<GunCraftSlotType, Attachment>();
            for (Map.Entry<GunCraftSlotType, RegistryObject> entry : possibleAttachments.entrySet()) {
                if (!random.nextBoolean()) continue;
                attachments.put(entry.getKey(), (Attachment)((Supplier)entry.getValue()).get());
            }
            gun.setAttachments(attachments);
        });
        return gunStack;
    }

    @Override
    protected ItemStack createHatItem() {
        return ((Item)ModItems.GREY_ARMY_HELMET.get()).m_7968_();
    }

    @Override
    protected ItemStack createClothingItem() {
        return ((Item)ModItems.ARMY_CLOTHING.get()).m_7968_();
    }

    @Override
    protected ItemStack createBackpackItem() {
        return this.createFilledBackpackItem(((Double)CraftingDeadSurvival.serverConfig.soldierZombieBackpackEquipChance.get()).floatValue(), ((Item)ModItems.MEDIUM_GREY_BACKPACK.get()).m_7968_(), this.createBackpackLootId("soldier_zombie_backpack_loot"));
    }

    @Override
    protected ItemStack createVestItem() {
        return this.createFilledVestItem(((Double)CraftingDeadSurvival.serverConfig.soldierZombieVestEquipChance.get()).floatValue(), ((Item)ModItems.GREY_TACTICAL_VEST.get()).m_7968_(), this.createVestLootId("soldier_zombie_vest_loot"));
    }

    @Override
    public void applyEquipmentDropChances() {
        Zombie zombie = (Zombie)this.extension.entity();
        this.extension.setEquipmentDropChance(Equipment.Slot.CLOTHING, ((Double)CraftingDeadSurvival.serverConfig.soldierZombieClothingDropChance.get()).floatValue());
        this.extension.setEquipmentDropChance(Equipment.Slot.HAT, ((Double)CraftingDeadSurvival.serverConfig.soldierZombieHatDropChance.get()).floatValue());
        this.extension.setEquipmentDropChance(Equipment.Slot.VEST, ((Double)CraftingDeadSurvival.serverConfig.soldierZombieVestDropChance.get()).floatValue());
        this.extension.setEquipmentDropChance(Equipment.Slot.BACKPACK, ((Double)CraftingDeadSurvival.serverConfig.soldierZombieBackpackDropChance.get()).floatValue());
        zombie.m_21409_(EquipmentSlot.MAINHAND, ((Double)CraftingDeadSurvival.serverConfig.soldierZombieHandDropChance.get()).floatValue());
        zombie.m_21409_(EquipmentSlot.OFFHAND, ((Double)CraftingDeadSurvival.serverConfig.soldierZombieHandDropChance.get()).floatValue());
    }
}

