/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.survival.world.entity.extension;

import com.craftingdead.core.world.entity.extension.BasicLivingExtension;
import com.craftingdead.core.world.item.GunItem;
import com.craftingdead.core.world.item.MagazineItem;
import com.craftingdead.core.world.item.ModItems;
import com.craftingdead.core.world.item.equipment.Equipment;
import com.craftingdead.core.world.item.gun.Gun;
import com.craftingdead.core.world.item.gun.ammoprovider.AmmoProvider;
import com.craftingdead.core.world.item.gun.ammoprovider.RefillableAmmoProvider;
import com.craftingdead.survival.CraftingDeadSurvival;
import com.craftingdead.survival.world.entity.extension.ZombieHandler;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PoliceZombieHandler
extends ZombieHandler {
    public PoliceZombieHandler(BasicLivingExtension<Zombie> extension) {
        super(extension);
    }

    @Override
    protected ItemStack createHeldItem() {
        ItemStack gunStack = ((GunItem)ModItems.G18.get()).m_7968_();
        gunStack.getCapability(Gun.CAPABILITY).ifPresent(gun -> gun.setAmmoProvider((AmmoProvider)new RefillableAmmoProvider(((MagazineItem)ModItems.G18_MAGAZINE.get()).m_7968_(), 2, false)));
        return gunStack;
    }

    @Override
    protected ItemStack createClothingItem() {
        return ((Item)ModItems.POLICE_CLOTHING.get()).m_7968_();
    }

    @Override
    protected ItemStack createHatItem() {
        return ItemStack.f_41583_;
    }

    @Override
    public void applyEquipmentDropChances() {
        Zombie zombie = (Zombie)this.extension.entity();
        this.extension.setEquipmentDropChance(Equipment.Slot.CLOTHING, ((Double)CraftingDeadSurvival.serverConfig.policeZombieClothingDropChance.get()).floatValue());
        this.extension.setEquipmentDropChance(Equipment.Slot.HAT, ((Double)CraftingDeadSurvival.serverConfig.policeZombieHatDropChance.get()).floatValue());
        this.extension.setEquipmentDropChance(Equipment.Slot.VEST, ((Double)CraftingDeadSurvival.serverConfig.policeZombieVestDropChance.get()).floatValue());
        this.extension.setEquipmentDropChance(Equipment.Slot.BACKPACK, ((Double)CraftingDeadSurvival.serverConfig.policeZombieBackpackDropChance.get()).floatValue());
        zombie.m_21409_(EquipmentSlot.MAINHAND, ((Double)CraftingDeadSurvival.serverConfig.policeZombieHandDropChance.get()).floatValue());
        zombie.m_21409_(EquipmentSlot.OFFHAND, ((Double)CraftingDeadSurvival.serverConfig.policeZombieHandDropChance.get()).floatValue());
    }
}

