/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.survival.world.entity;

import com.craftingdead.core.world.effect.ModMobEffects;
import com.craftingdead.core.world.entity.extension.LivingHandlerType;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.entity.extension.PlayerHandler;
import com.craftingdead.core.world.item.ClothingItem;
import com.craftingdead.core.world.item.GunItem;
import com.craftingdead.core.world.item.equipment.Equipment;
import com.craftingdead.survival.CraftingDeadSurvival;
import com.craftingdead.survival.world.effect.SurvivalMobEffects;
import java.util.Objects;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;

public class SurvivalPlayerHandler
implements PlayerHandler {
    public static final LivingHandlerType<SurvivalPlayerHandler> TYPE = new LivingHandlerType(new ResourceLocation("craftingdeadsurvival", "survival_player"));
    private static final float BASE_INFECTION_CHANCE = 0.1f;
    private static final float BASE_BLEEDING_CHANCE = 0.1f;
    private static final Random random = new Random();
    private final PlayerExtension<?> player;
    private int soundLevel;

    public SurvivalPlayerHandler(PlayerExtension<?> player) {
        this.player = player;
    }

    public PlayerExtension<?> getPlayer() {
        return this.player;
    }

    public int getSoundLevel() {
        return this.soundLevel;
    }

    public void addSoundLevel(int soundLevel) {
        this.soundLevel += soundLevel;
    }

    public void playerTick() {
        if (!this.player.level().m_5776_()) {
            this.updateEffects();
            if (((Player)this.player.entity()).f_19797_ % 5 == 0 && this.soundLevel > 0) {
                --this.soundLevel;
            }
        }
    }

    private void updateEffects() {
        boolean invulnerable;
        boolean bl = invulnerable = ((Player)this.player.entity()).m_150110_().f_35934_ || this.player.level().m_46791_() == Difficulty.PEACEFUL;
        if (((Player)this.player.entity()).m_21023_((MobEffect)ModMobEffects.BLEEDING.get()) && (invulnerable || !((Boolean)CraftingDeadSurvival.serverConfig.bleedingEnabled.get()).booleanValue())) {
            ((Player)this.player.entity()).m_21195_((MobEffect)ModMobEffects.BLEEDING.get());
        }
        if (((Player)this.player.entity()).m_21023_((MobEffect)SurvivalMobEffects.BROKEN_LEG.get()) && (invulnerable || !((Boolean)CraftingDeadSurvival.serverConfig.brokenLegsEnabled.get()).booleanValue())) {
            ((Player)this.player.entity()).m_21195_((MobEffect)SurvivalMobEffects.BROKEN_LEG.get());
        }
        if (((Player)this.player.entity()).m_21023_((MobEffect)SurvivalMobEffects.INFECTION.get()) && (invulnerable || !((Boolean)CraftingDeadSurvival.serverConfig.infectionEnabled.get()).booleanValue())) {
            ((Player)this.player.entity()).m_21195_((MobEffect)SurvivalMobEffects.INFECTION.get());
        }
    }

    public boolean handleHurt(DamageSource source, float amount) {
        if (source.m_7639_() instanceof Zombie && !(((Zombie)source.m_7639_()).m_21205_().m_41720_() instanceof GunItem)) {
            if (!this.player.getItemInSlot(Equipment.Slot.CLOTHING).m_41619_()) {
                this.infect(Objects.requireNonNull(ClothingItem.getClothingItem((Player)((Player)this.player.entity()))).calculateBleedAndInfectionChance(0.1f));
            } else {
                this.infect(0.1f);
            }
        }
        return false;
    }

    public void infect(float chance) {
        Player entity = (Player)this.player.entity();
        if (!entity.m_7500_() && entity.m_183503_().m_46791_() != Difficulty.PEACEFUL && entity.m_21187_().nextFloat() < chance && !entity.m_21023_((MobEffect)SurvivalMobEffects.INFECTION.get()) && ((Boolean)CraftingDeadSurvival.serverConfig.infectionEnabled.get()).booleanValue() && entity.m_7292_(new MobEffectInstance((MobEffect)SurvivalMobEffects.INFECTION.get(), 9999999))) {
            entity.m_5661_((Component)new TranslatableComponent("message.infected").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), true);
        }
    }

    public float handleDamaged(DamageSource source, float amount) {
        boolean invulnerable;
        boolean bl = invulnerable = ((Player)this.player.entity()).m_150110_().f_35934_ || this.player.level().m_46791_() == Difficulty.PEACEFUL;
        if (!invulnerable && ((Boolean)CraftingDeadSurvival.serverConfig.bleedingEnabled.get()).booleanValue() && !((Player)this.player.entity()).m_21023_((MobEffect)ModMobEffects.BLEEDING.get()) && (source.m_7640_() != null || source.m_19372_())) {
            float bleedChance = !this.player.getItemInSlot(Equipment.Slot.CLOTHING).m_41619_() ? Objects.requireNonNull(ClothingItem.getClothingItem((Player)((Player)this.player.entity()))).calculateBleedAndInfectionChance(0.1f) * amount : 0.1f * amount;
            if (random.nextFloat() < bleedChance && ((Player)this.player.entity()).m_7292_(new MobEffectInstance((MobEffect)ModMobEffects.BLEEDING.get(), 9999999))) {
                ((Player)this.player.entity()).m_5661_((Component)new TranslatableComponent("message.bleeding").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), true);
            }
        }
        if (!invulnerable && ((Boolean)CraftingDeadSurvival.serverConfig.brokenLegsEnabled.get()).booleanValue() && !((Player)this.player.entity()).m_21023_((MobEffect)SurvivalMobEffects.BROKEN_LEG.get()) && source == DamageSource.f_19315_) {
            double legBreakChance = (Double)CraftingDeadSurvival.serverConfig.brokenLegChance.get() * (double)((Player)this.player.entity()).f_19789_ / (double)((Player)this.player.entity()).m_6056_();
            if ((double)random.nextFloat() < legBreakChance && ((Player)this.player.entity()).m_7292_(new MobEffectInstance((MobEffect)SurvivalMobEffects.BROKEN_LEG.get(), 9999999, 4))) {
                ((Player)this.player.entity()).m_5661_((Component)new TranslatableComponent("message.broken_leg").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), true);
                ((Player)this.player.entity()).m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 1));
            }
        }
        return amount;
    }

    public void encode(FriendlyByteBuf out, boolean writeAll) {
    }

    public void decode(FriendlyByteBuf in) {
    }

    public boolean requiresSync() {
        return false;
    }
}

