/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.survival.data.models;

import com.craftingdead.survival.data.models.SurvivalItemModelGenerators;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SurvivalModelProvider
implements DataProvider {
    private static final Logger logger = LogManager.getLogger();
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DataGenerator generator;

    public SurvivalModelProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_6865_(HashCache directoryCache) {
        HashMap models = Maps.newHashMap();
        BiConsumer<ResourceLocation, Supplier<JsonElement>> modelConsumer = (model, json) -> {
            Supplier existingJson = models.put(model, json);
            if (existingJson != null) {
                throw new IllegalStateException("Duplicate model definition for " + model);
            }
        };
        new SurvivalItemModelGenerators(modelConsumer).run();
        Path outputFolder = this.generator.m_123916_();
        this.saveCollection(directoryCache, outputFolder, models, SurvivalModelProvider::createModelPath);
    }

    private <T> void saveCollection(HashCache p_240081_1_, Path p_240081_2_, Map<T, ? extends Supplier<JsonElement>> p_240081_3_, BiFunction<Path, T, Path> p_240081_4_) {
        p_240081_3_.forEach((p_240088_3_, p_240088_4_) -> {
            Path path = (Path)p_240081_4_.apply(p_240081_2_, p_240088_3_);
            try {
                DataProvider.m_123920_((Gson)gson, (HashCache)p_240081_1_, (JsonElement)((JsonElement)p_240088_4_.get()), (Path)path);
            }
            catch (Exception exception) {
                logger.error("Couldn't save {}", (Object)path, (Object)exception);
            }
        });
    }

    private static Path createModelPath(Path parentDir, ResourceLocation modelLocation) {
        return parentDir.resolve("assets/" + modelLocation.m_135827_() + "/models/" + modelLocation.m_135815_() + ".json");
    }

    public String m_6055_() {
        return "Railcraft Block State Definitions";
    }
}

