/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.survival.client.model.geom;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.resources.ResourceLocation;

public class SurvivalModelLayers {
    private static final String DEFAULT_LAYER = "main";
    private static final Set<ModelLayerLocation> allModels = Sets.newHashSet();
    public static final ModelLayerLocation SUPPLY_DROP = SurvivalModelLayers.register("supply_drop");
    public static final ModelLayerLocation PIPE_BOMB = SurvivalModelLayers.register("pipe_bomb");

    private static ModelLayerLocation register(String model) {
        return SurvivalModelLayers.register(model, DEFAULT_LAYER);
    }

    private static ModelLayerLocation register(String model, String layer) {
        ModelLayerLocation location = SurvivalModelLayers.createLocation(model, layer);
        if (!allModels.add(location)) {
            throw new IllegalStateException("Duplicate registration for " + location);
        }
        return location;
    }

    private static ModelLayerLocation createLocation(String model, String layer) {
        return new ModelLayerLocation(new ResourceLocation("craftingdeadsurvival", model), layer);
    }
}

