/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.survival.client;

import com.craftingdead.core.CraftingDead;
import com.craftingdead.core.client.ClientConfig;
import com.craftingdead.core.client.renderer.entity.grenade.GrenadeRenderer;
import com.craftingdead.core.client.renderer.entity.layers.ParachuteLayer;
import com.craftingdead.core.client.util.RenderUtil;
import com.craftingdead.core.world.effect.ModMobEffects;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.survival.ModDist;
import com.craftingdead.survival.client.model.PipeBombModel;
import com.craftingdead.survival.client.model.SupplyDropModel;
import com.craftingdead.survival.client.model.geom.SurvivalModelLayers;
import com.craftingdead.survival.client.renderer.entity.AdvancedZombieRenderer;
import com.craftingdead.survival.client.renderer.entity.GiantZombieRenderer;
import com.craftingdead.survival.client.renderer.entity.SupplyDropRenderer;
import com.craftingdead.survival.particles.SurvivalParticleTypes;
import com.craftingdead.survival.world.entity.SurvivalEntityTypes;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.SpellParticle;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
public class ClientDist
implements ModDist {
    public static final ClientConfig clientConfig;
    public static final ForgeConfigSpec clientConfigSpec;
    private static final ResourceLocation BLOOD;
    private static final ResourceLocation BLOOD_2;
    private final Minecraft minecraft = Minecraft.m_91087_();

    public ClientDist() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::handleEntityRenderers);
        modEventBus.addListener(this::handleEntityRenderersAddLayers);
        modEventBus.addListener(this::handleParticleFactoryRegisterEvent);
        modEventBus.addListener(this::handleEntityRenderersLayerDefinitions);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)clientConfigSpec);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void handleEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)SurvivalEntityTypes.PIPE_BOMB.get(), context -> new GrenadeRenderer(context, context.m_174023_(SurvivalModelLayers.PIPE_BOMB)));
        event.registerEntityRenderer((EntityType)SurvivalEntityTypes.SUPPLY_DROP.get(), SupplyDropRenderer::new);
        event.registerEntityRenderer(EntityType.f_20501_, AdvancedZombieRenderer::new);
        event.registerEntityRenderer((EntityType)SurvivalEntityTypes.FAST_ZOMBIE.get(), AdvancedZombieRenderer::new);
        event.registerEntityRenderer((EntityType)SurvivalEntityTypes.TANK_ZOMBIE.get(), AdvancedZombieRenderer::new);
        event.registerEntityRenderer((EntityType)SurvivalEntityTypes.WEAK_ZOMBIE.get(), AdvancedZombieRenderer::new);
        event.registerEntityRenderer((EntityType)SurvivalEntityTypes.POLICE_ZOMBIE.get(), AdvancedZombieRenderer::new);
        event.registerEntityRenderer((EntityType)SurvivalEntityTypes.DOCTOR_ZOMBIE.get(), AdvancedZombieRenderer::new);
        event.registerEntityRenderer((EntityType)SurvivalEntityTypes.GIANT_ZOMBIE.get(), GiantZombieRenderer::new);
        event.registerEntityRenderer((EntityType)SurvivalEntityTypes.SCOUT_ZOMBIE.get(), AdvancedZombieRenderer::new);
        event.registerEntityRenderer((EntityType)SurvivalEntityTypes.SNIPER_ZOMBIE.get(), AdvancedZombieRenderer::new);
        event.registerEntityRenderer((EntityType)SurvivalEntityTypes.PILOT_ZOMBIE.get(), AdvancedZombieRenderer::new);
        event.registerEntityRenderer((EntityType)SurvivalEntityTypes.SOLDIER_ZOMBIE.get(), AdvancedZombieRenderer::new);
        event.registerEntityRenderer((EntityType)SurvivalEntityTypes.NINJA_ZOMBIE.get(), AdvancedZombieRenderer::new);
        event.registerEntityRenderer((EntityType)SurvivalEntityTypes.ALFA_ZOMBIE.get(), AdvancedZombieRenderer::new);
        event.registerEntityRenderer((EntityType)SurvivalEntityTypes.BOUNTY_HUNTER_ZOMBIE.get(), AdvancedZombieRenderer::new);
        event.registerEntityRenderer((EntityType)SurvivalEntityTypes.DESERT_RAIDER_ZOMBIE.get(), AdvancedZombieRenderer::new);
        event.registerEntityRenderer((EntityType)SurvivalEntityTypes.FIREFIGHTER_ZOMBIE.get(), AdvancedZombieRenderer::new);
        event.registerEntityRenderer((EntityType)SurvivalEntityTypes.HAZMAT_ZOMBIE.get(), AdvancedZombieRenderer::new);
        event.registerEntityRenderer((EntityType)SurvivalEntityTypes.JUGGERNAUT_ZOMBIE.get(), AdvancedZombieRenderer::new);
        event.registerEntityRenderer((EntityType)SurvivalEntityTypes.MINER_ZOMBIE.get(), AdvancedZombieRenderer::new);
        event.registerEntityRenderer((EntityType)SurvivalEntityTypes.SWAT_ZOMBIE.get(), AdvancedZombieRenderer::new);
    }

    private void handleEntityRenderersAddLayers(EntityRenderersEvent.AddLayers event) {
        LivingEntityRenderer soliderZombie = event.getRenderer((EntityType)SurvivalEntityTypes.SOLDIER_ZOMBIE.get());
        LivingEntityRenderer fastZombie = event.getRenderer((EntityType)SurvivalEntityTypes.FAST_ZOMBIE.get());
        LivingEntityRenderer scoutZombie = event.getRenderer((EntityType)SurvivalEntityTypes.SCOUT_ZOMBIE.get());
        if (soliderZombie instanceof AdvancedZombieRenderer) {
            AdvancedZombieRenderer soldierZombieRenderer = (AdvancedZombieRenderer)soliderZombie;
            soldierZombieRenderer.m_115326_((RenderLayer)new ParachuteLayer((RenderLayerParent)soldierZombieRenderer, event.getEntityModels()));
        }
        if (fastZombie instanceof AdvancedZombieRenderer) {
            AdvancedZombieRenderer fastZombieRenderer = (AdvancedZombieRenderer)fastZombie;
            fastZombieRenderer.m_115326_((RenderLayer)new ParachuteLayer((RenderLayerParent)fastZombieRenderer, event.getEntityModels()));
        }
        if (scoutZombie instanceof AdvancedZombieRenderer) {
            AdvancedZombieRenderer scoutZombieRenderer = (AdvancedZombieRenderer)scoutZombie;
            scoutZombieRenderer.m_115326_((RenderLayer)new ParachuteLayer((RenderLayerParent)scoutZombieRenderer, event.getEntityModels()));
        }
    }

    private void handleEntityRenderersLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(SurvivalModelLayers.SUPPLY_DROP, SupplyDropModel::createBodyLayer);
        event.registerLayerDefinition(SurvivalModelLayers.PIPE_BOMB, PipeBombModel::createBodyLayer);
    }

    private void handleParticleFactoryRegisterEvent(ParticleFactoryRegisterEvent event) {
        ParticleEngine particleEngine = this.minecraft.f_91061_;
        particleEngine.m_107378_((ParticleType)SurvivalParticleTypes.MILITARY_LOOT_GEN.get(), SpellParticle.Provider::new);
        particleEngine.m_107378_((ParticleType)SurvivalParticleTypes.MEDIC_LOOT_GEN.get(), SpellParticle.Provider::new);
        particleEngine.m_107378_((ParticleType)SurvivalParticleTypes.CIVILIAN_LOOT_GEN.get(), SpellParticle.Provider::new);
        particleEngine.m_107378_((ParticleType)SurvivalParticleTypes.CIVILIAN_RARE_LOOT_GEN.get(), SpellParticle.Provider::new);
        particleEngine.m_107378_((ParticleType)SurvivalParticleTypes.POLICE_LOOT_GEN.get(), SpellParticle.Provider::new);
    }

    @SubscribeEvent
    public void handleRenderGameOverlayPre(RenderGameOverlayEvent.Pre event) {
        PlayerExtension player = CraftingDead.getInstance().getClientDist().getCameraPlayer();
        if (player == null) {
            return;
        }
        switch (event.getType()) {
            case ALL: {
                if (!this.minecraft.f_91072_.m_105205_() || player.isCombatModeEnabled()) break;
                float healthPercentage = ((AbstractClientPlayer)player.entity()).m_21223_() / ((AbstractClientPlayer)player.entity()).m_21233_();
                if (!((Boolean)ClientDist.clientConfig.displayBlood.get()).booleanValue() || !(healthPercentage < 1.0f) || !((AbstractClientPlayer)player.entity()).m_21023_((MobEffect)ModMobEffects.BLEEDING.get())) break;
                ClientDist.renderBlood(event.getWindow().m_85445_(), event.getWindow().m_85446_(), healthPercentage);
                break;
            }
        }
    }

    private static void renderBlood(int width, int height, float healthPercentage) {
        RenderSystem.m_69478_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)(healthPercentage <= 0.25f ? BLOOD_2 : BLOOD));
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - healthPercentage));
        RenderUtil.blit((float)0.0f, (float)0.0f, (float)width, (float)height);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69461_();
    }

    static {
        Pair clientConfigPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        clientConfigSpec = (ForgeConfigSpec)clientConfigPair.getRight();
        clientConfig = (ClientConfig)clientConfigPair.getLeft();
        BLOOD = new ResourceLocation("craftingdeadsurvival", "textures/gui/blood.png");
        BLOOD_2 = new ResourceLocation("craftingdeadsurvival", "textures/gui/blood_2.png");
    }
}

