/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.view;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.StringDecomposer;
import net.minecraftforge.common.ForgeHooks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import sm0keysa1m0n.bliss.Bliss;
import sm0keysa1m0n.bliss.Length;
import sm0keysa1m0n.bliss.style.parser.ParserException;
import sm0keysa1m0n.bliss.view.DownloadUtil;
import sm0keysa1m0n.bliss.view.ImageAccess;
import sm0keysa1m0n.bliss.view.ImageView;
import sm0keysa1m0n.bliss.view.LoggingErrorHandler;
import sm0keysa1m0n.bliss.view.ParentView;
import sm0keysa1m0n.bliss.view.TextView;
import sm0keysa1m0n.bliss.view.View;

public class ViewUtil {
    private static final Logger logger = LoggerFactory.getLogger(ViewUtil.class);

    public static void addAll(ParentView parentView, File file) {
        ViewUtil.addAll(parentView, file, view -> {
            try {
                view.getStyle().getStyleManager().parseInline("flex: 1;");
            }
            catch (ParserException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    public static void addAll(ParentView parentView, File file, Consumer<View> configurer) {
        CompletableFuture<Document> documentFuture;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(LoggingErrorHandler.INSTANCE);
            documentFuture = CompletableFuture.supplyAsync(() -> {
                try {
                    return builder.parse(file);
                }
                catch (IOException | SAXException e) {
                    logger.warn("Failed to parse xml {} {}", (Object)file.getAbsolutePath(), (Object)e);
                    return null;
                }
            }, Bliss.instance().platform().backgroundExecutor());
        }
        catch (ParserConfigurationException e) {
            logger.warn("Failed to create document builder", (Throwable)e);
            return;
        }
        documentFuture.thenAcceptAsync(document -> ViewUtil.parseDocument(document, file, parentView, configurer), Bliss.instance().platform().mainExecutor());
    }

    private static void parseDocument(Document document, File file, ParentView parentView, Consumer<View> configurer) {
        NodeList nodes = document.getDocumentElement().getChildNodes();
        block12: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeName()) {
                case "text": {
                    String text = node.getTextContent();
                    if (text == null) continue block12;
                    TextView view = new TextView(new View.Properties()).setText((FormattedText)ViewUtil.extractStyles(ForgeHooks.newChatWithLinks((String)text)));
                    Node styleNode = node.getAttributes().getNamedItem("style");
                    if (styleNode != null && styleNode.getNodeValue() != null) {
                        try {
                            view.getStyle().getStyleManager().parseInline(styleNode.getNodeValue());
                        }
                        catch (ParserException e) {
                            logger.warn("Invalid style: {}", (Object)styleNode.getNodeValue(), (Object)e);
                        }
                    }
                    view.getStyle().width.set(Length.percentage(100.0f));
                    parentView.addChild(view);
                    continue block12;
                }
                case "image": {
                    String url = null;
                    Node urlNode = node.getAttributes().getNamedItem("url");
                    if (urlNode == null || urlNode.getNodeValue() == null) {
                        logger.warn("No URL declared for image in {}", (Object)file.getAbsolutePath());
                        continue block12;
                    }
                    url = urlNode.getNodeValue();
                    ImageView view = new ImageView(new View.Properties());
                    Node styleNode = node.getAttributes().getNamedItem("style");
                    if (styleNode != null && styleNode.getNodeValue() != null) {
                        try {
                            view.getStyle().getStyleManager().parseInline(styleNode.getNodeValue());
                        }
                        catch (ParserException e) {
                            logger.warn("Invalid style: {}", (Object)styleNode.getNodeValue(), (Object)e);
                        }
                    }
                    parentView.addChild(view);
                    DownloadUtil.downloadImage(url).thenAcceptAsync(result -> result.ifPresent(image -> {
                        view.setImage(ImageAccess.forImage(image));
                        if (parentView.isAdded()) {
                            parentView.layout();
                        }
                    }), Bliss.instance().platform().mainExecutor());
                    continue block12;
                }
            }
        }
        if (parentView.isAdded()) {
            parentView.layout();
        }
    }

    public static Component extractStyles(Component component) {
        ComponentBuilder builder = new ComponentBuilder();
        StringDecomposer.m_14328_((FormattedText)component, (Style)Style.f_131099_, (FormattedCharSink)builder);
        return builder.getComponent();
    }

    private static class ComponentBuilder
    implements FormattedCharSink {
        private MutableComponent component = TextComponent.f_131282_.m_6881_();
        private StringBuilder builder;
        private Style style;

        private ComponentBuilder() {
        }

        public boolean m_6411_(int index, Style style, int codePoint) {
            if (this.style != style) {
                if (this.builder != null) {
                    this.component.m_7220_((Component)new TextComponent(this.builder.toString()).m_6270_(this.style));
                }
                this.builder = new StringBuilder();
                this.style = style;
            }
            this.builder.append((char)codePoint);
            return true;
        }

        public Component getComponent() {
            return this.component;
        }
    }
}

