/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.view;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.humbleui.skija.Canvas;
import io.github.humbleui.skija.FontMgr;
import io.github.humbleui.skija.FontStyle;
import io.github.humbleui.skija.Paint;
import io.github.humbleui.skija.Picture;
import io.github.humbleui.skija.PictureRecorder;
import io.github.humbleui.skija.paragraph.Alignment;
import io.github.humbleui.skija.paragraph.DecorationStyle;
import io.github.humbleui.skija.paragraph.FontCollection;
import io.github.humbleui.skija.paragraph.Paragraph;
import io.github.humbleui.skija.paragraph.ParagraphBuilder;
import io.github.humbleui.skija.paragraph.ParagraphStyle;
import io.github.humbleui.skija.paragraph.Shadow;
import io.github.humbleui.skija.paragraph.TextStyle;
import io.github.humbleui.types.Rect;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import sm0keysa1m0n.bliss.Color;
import sm0keysa1m0n.bliss.layout.Layout;
import sm0keysa1m0n.bliss.layout.MeasureMode;
import sm0keysa1m0n.bliss.view.View;

public class TextView
extends View {
    private FormattedText text = TextComponent.f_131282_;
    private boolean wrap = true;
    @Nullable
    private Paragraph paragraph = null;
    private int textCount;
    private FontMgr fontManager = FontMgr.getDefault();

    public TextView(View.Properties properties) {
        super(properties);
        this.getStyle().color.addListener(color -> {
            if (this.paragraph != null && this.isAdded()) {
                this.paragraph.updateForegroundPaint(0, this.textCount, new Paint().setColor(color.valueHex()));
                this.paragraph.layout(this.getContentWidth() * this.graphicsContext.scale());
            }
        });
        this.getStyle().fontFamily.addListener(__ -> this.buildParagraph());
        this.getStyle().fontSize.addListener(fontSize -> {
            if (this.paragraph != null && this.isAdded()) {
                this.paragraph.updateFontSize(0, this.textCount, (float)fontSize.intValue());
                this.paragraph.layout(this.getContentWidth() * this.graphicsContext.scale());
            }
        });
        this.getStyle().textAlign.addListener(textAlign -> {
            if (this.paragraph != null && this.isAdded()) {
                this.paragraph.updateAlignment(textAlign);
                this.paragraph.layout(this.getContentWidth() * this.graphicsContext.scale());
            }
        });
        this.getStyle().textShadow.addListener(__ -> this.buildParagraph());
    }

    @Override
    public void styleRefreshed(FontMgr fontManager) {
        if (this.fontManager != FontMgr.getDefault()) {
            this.fontManager.close();
        }
        this.fontManager = fontManager;
        this.buildParagraph();
    }

    @Override
    protected void setLayout(Layout layout) {
        super.setLayout(layout);
        layout.setMeasureFunction(this::measure);
    }

    public TextView setWrap(boolean wrap) {
        this.wrap = wrap;
        if (this.isAdded()) {
            this.getLayout().markDirty();
            this.parent.layout();
        }
        return this;
    }

    public TextView setText(@Nullable String text) {
        return this.setText((FormattedText)Component.m_130674_((String)text));
    }

    public TextView setText(FormattedText text) {
        this.text = text;
        this.buildParagraph();
        if (this.isAdded()) {
            this.getLayout().markDirty();
            this.parent.layout();
        }
        return this;
    }

    private void buildParagraph() {
        if (this.paragraph != null) {
            this.paragraph.close();
            this.paragraph = null;
        }
        this.textCount = 0;
        try (ParagraphStyle paragraphStyle = new ParagraphStyle().setAlignment((Alignment)this.getStyle().textAlign.get()).setEllipsis("...").setMaxLinesCount(this.wrap ? Integer.MAX_VALUE : 1L);
             FontCollection fontCollection = new FontCollection().setDefaultFontManager(this.fontManager).setDynamicFontManager(FontMgr.getDefault());
             ParagraphBuilder builder = new ParagraphBuilder(paragraphStyle, fontCollection);){
            this.text.m_7451_((style, content) -> {
                int color = style.m_131135_() == null ? ((Color)this.getStyle().color.get()).valueHex() : style.m_131135_().m_131265_() + -16777216;
                try (TextStyle textStyle = new TextStyle().setFontSize((float)((Integer)this.getStyle().fontSize.get()).intValue() * this.graphicsContext.scale()).setFontFamilies((String[])this.getStyle().fontFamily.get()).addShadows((Shadow[])this.getStyle().textShadow.get()).setColor(color).setFontStyle(style.m_131154_() && style.m_131161_() ? FontStyle.BOLD_ITALIC : (style.m_131154_() ? FontStyle.BOLD : (style.m_131161_() ? FontStyle.ITALIC : FontStyle.NORMAL))).setDecorationStyle(DecorationStyle.NONE.withUnderline(style.m_131171_()).withLineThrough(style.m_131168_()).withColor(color));){
                    builder.pushStyle(textStyle);
                    builder.addText(content);
                    this.textCount += content.length();
                    builder.popStyle();
                }
                return Optional.empty();
            }, Style.f_131099_);
            this.paragraph = builder.build();
        }
    }

    @Override
    public void layout() {
        if (this.paragraph != null) {
            this.paragraph.updateFontSize(0, this.textCount, (float)((Integer)this.getStyle().fontSize.get()).intValue() * this.graphicsContext.scale());
            this.paragraph.layout(this.getContentWidth() * this.graphicsContext.scale());
        }
        super.layout();
    }

    private Vec2 measure(MeasureMode widthMode, float width, MeasureMode heightMode, float height) {
        this.paragraph.updateFontSize(0, this.textCount, (float)((Integer)this.getStyle().fontSize.get()).intValue() * this.graphicsContext.scale());
        switch (widthMode) {
            case UNDEFINED: 
            case AT_MOST: {
                this.paragraph.layout(widthMode == MeasureMode.UNDEFINED ? Float.MAX_VALUE : (float)Mth.m_14167_((float)width) * this.graphicsContext.scale());
                width = this.paragraph.getMaxIntrinsicWidth() / this.graphicsContext.scale();
                break;
            }
            default: {
                this.paragraph.layout((float)Mth.m_14167_((float)width) * this.graphicsContext.scale());
            }
        }
        return new Vec2(width, this.paragraph.getHeight() / this.graphicsContext.scale());
    }

    @Override
    public float computeFullHeight() {
        return this.paragraph == null ? super.computeFullHeight() : this.paragraph.getHeight() / this.graphicsContext.scale();
    }

    @Override
    public void renderContent(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.renderContent(poseStack, mouseX, mouseY, partialTicks);
        if (this.paragraph != null) {
            Canvas canvas = this.graphicsContext.canvas();
            canvas.translate(this.getScaledContentX() * this.graphicsContext.scale(), this.getScaledContentY() * this.graphicsContext.scale());
            canvas.scale(this.getXScale(), this.getYScale());
            try (PictureRecorder recorder = new PictureRecorder();){
                Canvas recordingCanvas = recorder.beginRecording(Rect.makeWH((float)this.paragraph.getMaxWidth(), (float)this.paragraph.getHeight()));
                this.paragraph.paint(recordingCanvas, 0.0f, 0.0f);
                Picture picture = recorder.finishRecordingAsPicture();
                try (Paint paint = new Paint().setAlphaf(this.getAlpha());){
                    canvas.drawPicture(picture, null, paint);
                }
            }
            canvas.resetMatrix();
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.paragraph != null) {
            this.paragraph.close();
            this.paragraph = null;
        }
        if (this.fontManager != FontMgr.getDefault()) {
            this.fontManager.close();
        }
    }
}

