/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.view;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.humbleui.skija.BlendMode;
import io.github.humbleui.skija.Canvas;
import io.github.humbleui.skija.ColorFilter;
import io.github.humbleui.skija.Paint;
import io.github.humbleui.skija.PaintMode;
import io.github.humbleui.types.Point;
import io.github.humbleui.types.Rect;
import java.util.Optional;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import sm0keysa1m0n.bliss.Color;
import sm0keysa1m0n.bliss.ImageRendering;
import sm0keysa1m0n.bliss.ObjectFit;
import sm0keysa1m0n.bliss.layout.Layout;
import sm0keysa1m0n.bliss.layout.MeasureMode;
import sm0keysa1m0n.bliss.view.ImageAccess;
import sm0keysa1m0n.bliss.view.View;

public class ImageView
extends View {
    @Nullable
    private ImageAccess image;
    private Vec2 fittedImageSize;

    public ImageView(View.Properties properties) {
        super(properties);
    }

    @Override
    protected void setLayout(Layout layout) {
        super.setLayout(layout);
        layout.setMeasureFunction(this::measure);
    }

    public ImageView setImage(@Nullable ImageAccess image) {
        if (this.image != null) {
            this.image.close();
        }
        this.image = image;
        this.getLayout().markDirty();
        return this;
    }

    private Optional<Vec2> getFittedImageSize() {
        return this.getFittedImageSize(this.getContentWidth(), this.getContentHeight());
    }

    private Optional<Vec2> getFittedImageSize(float containerWidth, float containerHeight) {
        if (this.image == null) {
            return Optional.empty();
        }
        Point size = this.image.getIntrinsicSize(containerWidth, containerHeight);
        return Optional.of(((ObjectFit)((Object)this.getStyle().objectFit.get())).getSize(size.getX(), size.getY(), containerWidth, containerHeight));
    }

    @Override
    public void layout() {
        super.layout();
        this.fittedImageSize = this.getFittedImageSize().orElse(null);
        if (this.fittedImageSize != null) {
            this.image.prepare(this.fittedImageSize.f_82470_ * this.graphicsContext.scale(), this.fittedImageSize.f_82471_ * this.graphicsContext.scale());
        }
    }

    private Vec2 measure(MeasureMode widthMode, float width, MeasureMode heightMode, float height) {
        return this.getFittedImageSize(widthMode == MeasureMode.UNDEFINED ? 2.1474836E9f : width, heightMode == MeasureMode.UNDEFINED ? 2.1474836E9f : height).orElse(new Vec2(width, height));
    }

    @Override
    public void renderContent(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.renderContent(matrixStack, mouseX, mouseY, partialTicks);
        Canvas canvas = this.graphicsContext.canvas();
        if (this.image == null) {
            try (Paint paint = new Paint();){
                paint.setAlphaf(this.getAlpha()).setColor(0xFFFFFF).setMode(PaintMode.FILL);
                float scale = this.graphicsContext.scale();
                canvas.drawRect(Rect.makeXYWH((float)(this.getScaledContentX() * scale), (float)(this.getScaledContentY() * scale), (float)(this.getScaledContentWidth() * scale), (float)(this.getScaledContentHeight() * scale)), paint);
            }
            return;
        }
        canvas.translate(this.getScaledContentX() * this.graphicsContext.scale(), this.getScaledContentY() * this.graphicsContext.scale());
        canvas.scale(this.getXScale(), this.getYScale());
        try (Paint paint = new Paint();){
            paint.setColorFilter(ColorFilter.makeBlend((int)((Color)this.getStyle().color.get()).multiplied(this.getAlpha()), (BlendMode)BlendMode.MODULATE));
            this.image.draw(canvas, paint, (ImageRendering)((Object)this.getStyle().imageRendering.get()));
        }
        canvas.resetMatrix();
    }

    @Override
    public void close() {
        super.close();
        if (this.image != null) {
            this.image.close();
            this.image = null;
        }
    }
}

