/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.view;

import io.github.humbleui.skija.Image;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sm0keysa1m0n.bliss.Bliss;

public class DownloadUtil {
    private static final Logger logger = LoggerFactory.getLogger(DownloadUtil.class);
    private static final String USER_AGENT = "Bliss";

    public static CompletableFuture<Optional<Image>> downloadImage(String imageUrl) {
        return CompletableFuture.supplyAsync(() -> {
            HttpURLConnection httpUrlConnection = null;
            logger.debug("Downloading image from {} to {}", (Object)imageUrl);
            try {
                httpUrlConnection = (HttpURLConnection)new URL(imageUrl).openConnection(Minecraft.m_91087_().m_91096_());
                httpUrlConnection.setRequestProperty("User-Agent", USER_AGENT);
                httpUrlConnection.setDoInput(true);
                httpUrlConnection.setDoOutput(false);
                httpUrlConnection.connect();
                if (httpUrlConnection.getResponseCode() / 100 == 2) {
                    Optional<Image> optional = Optional.of(Image.makeFromEncoded((byte[])httpUrlConnection.getInputStream().readAllBytes()));
                    return optional;
                }
            }
            catch (Throwable t) {
                logger.error("Couldn't download image", t);
            }
            finally {
                if (httpUrlConnection != null) {
                    httpUrlConnection.disconnect();
                }
            }
            return Optional.empty();
        }, Bliss.instance().platform().backgroundExecutor());
    }
}

