/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.minecraft;

import io.github.humbleui.skija.Data;
import io.github.humbleui.skija.Image;
import io.github.humbleui.skija.svg.SVGDOM;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sm0keysa1m0n.bliss.view.ImageAccess;
import sm0keysa1m0n.bliss.view.SimpleImageAccess;
import sm0keysa1m0n.bliss.view.SvgImageAccess;

public class MinecraftUtil {
    private static final Logger logger = LoggerFactory.getLogger(MinecraftUtil.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static ImageAccess createImageAccess(ResourceLocation imageLocation) {
        try (InputStream inputStream = Minecraft.m_91087_().m_91098_().m_142591_(imageLocation).m_6679_();){
            byte[] bytes = inputStream.readAllBytes();
            if (imageLocation.m_135815_().endsWith(".svg")) {
                SvgImageAccess svgImageAccess = new SvgImageAccess(new SVGDOM(Data.makeFromBytes((byte[])bytes)));
                return svgImageAccess;
            }
            SimpleImageAccess simpleImageAccess = new SimpleImageAccess(Image.makeFromEncoded((byte[])bytes));
            return simpleImageAccess;
        }
        catch (IOException e) {
            logger.warn("Failed to load image: {}", (Object)imageLocation);
            return null;
        }
    }
}

