/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.yoga;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.yoga.CompactValue;
import org.lwjgl.util.yoga.LibYoga;
import org.lwjgl.util.yoga.YGFloatOptional;

public class YGStyle
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLEX;
    public static final int FLEXGROW;
    public static final int FLEXSHRINK;
    public static final int FLEXBASIS;
    public static final int MARGIN;
    public static final int POSITIONS;
    public static final int PADDING;
    public static final int BORDER;
    public static final int DIMENSIONS;
    public static final int MINDIMENSIONS;
    public static final int MAXDIMENSIONS;
    public static final int ASPECTRATIO;

    private static native int offsets(long var0);

    public YGStyle(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), YGStyle.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="YGDirection")
    public int direction() {
        return YGStyle.ndirection(this.address());
    }

    @NativeType(value="YGFlexDirection")
    public int flexDirection() {
        return YGStyle.nflexDirection(this.address());
    }

    @NativeType(value="YGJustify")
    public int justifyContent() {
        return YGStyle.njustifyContent(this.address());
    }

    @NativeType(value="YGAlign")
    public int alignContent() {
        return YGStyle.nalignContent(this.address());
    }

    @NativeType(value="YGAlign")
    public int alignItems() {
        return YGStyle.nalignItems(this.address());
    }

    @NativeType(value="YGAlign")
    public int alignSelf() {
        return YGStyle.nalignSelf(this.address());
    }

    @NativeType(value="YGPositionType")
    public int positionType() {
        return YGStyle.npositionType(this.address());
    }

    @NativeType(value="YGWrap")
    public int flexWrap() {
        return YGStyle.nflexWrap(this.address());
    }

    @NativeType(value="YGOverflow")
    public int overflow() {
        return YGStyle.noverflow(this.address());
    }

    @NativeType(value="YGDisplay")
    public int display() {
        return YGStyle.ndisplay(this.address());
    }

    public YGFloatOptional flex() {
        return YGStyle.nflex(this.address());
    }

    public YGFloatOptional flexGrow() {
        return YGStyle.nflexGrow(this.address());
    }

    public YGFloatOptional flexShrink() {
        return YGStyle.nflexShrink(this.address());
    }

    public CompactValue flexBasis() {
        return YGStyle.nflexBasis(this.address());
    }

    @NativeType(value="CompactValue[9]")
    public CompactValue.Buffer margin() {
        return YGStyle.nmargin(this.address());
    }

    public CompactValue margin(int index) {
        return YGStyle.nmargin(this.address(), index);
    }

    @NativeType(value="CompactValue[9]")
    public CompactValue.Buffer positions() {
        return YGStyle.npositions(this.address());
    }

    public CompactValue positions(int index) {
        return YGStyle.npositions(this.address(), index);
    }

    @NativeType(value="CompactValue[9]")
    public CompactValue.Buffer padding() {
        return YGStyle.npadding(this.address());
    }

    public CompactValue padding(int index) {
        return YGStyle.npadding(this.address(), index);
    }

    @NativeType(value="CompactValue[9]")
    public CompactValue.Buffer border() {
        return YGStyle.nborder(this.address());
    }

    public CompactValue border(int index) {
        return YGStyle.nborder(this.address(), index);
    }

    @NativeType(value="CompactValue[2]")
    public CompactValue.Buffer dimensions() {
        return YGStyle.ndimensions(this.address());
    }

    public CompactValue dimensions(int index) {
        return YGStyle.ndimensions(this.address(), index);
    }

    @NativeType(value="CompactValue[2]")
    public CompactValue.Buffer minDimensions() {
        return YGStyle.nminDimensions(this.address());
    }

    public CompactValue minDimensions(int index) {
        return YGStyle.nminDimensions(this.address(), index);
    }

    @NativeType(value="CompactValue[2]")
    public CompactValue.Buffer maxDimensions() {
        return YGStyle.nmaxDimensions(this.address());
    }

    public CompactValue maxDimensions(int index) {
        return YGStyle.nmaxDimensions(this.address(), index);
    }

    public YGFloatOptional aspectRatio() {
        return YGStyle.naspectRatio(this.address());
    }

    public static YGStyle create(long address) {
        return (YGStyle)YGStyle.wrap(YGStyle.class, (long)address);
    }

    @Nullable
    public static YGStyle createSafe(long address) {
        return address == 0L ? null : (YGStyle)YGStyle.wrap(YGStyle.class, (long)address);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)YGStyle.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)YGStyle.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static native int ndirection(long var0);

    public static native int nflexDirection(long var0);

    public static native int njustifyContent(long var0);

    public static native int nalignContent(long var0);

    public static native int nalignItems(long var0);

    public static native int nalignSelf(long var0);

    public static native int npositionType(long var0);

    public static native int nflexWrap(long var0);

    public static native int noverflow(long var0);

    public static native int ndisplay(long var0);

    public static YGFloatOptional nflex(long struct) {
        return YGFloatOptional.create(struct + (long)FLEX);
    }

    public static YGFloatOptional nflexGrow(long struct) {
        return YGFloatOptional.create(struct + (long)FLEXGROW);
    }

    public static YGFloatOptional nflexShrink(long struct) {
        return YGFloatOptional.create(struct + (long)FLEXSHRINK);
    }

    public static CompactValue nflexBasis(long struct) {
        return CompactValue.create(struct + (long)FLEXBASIS);
    }

    public static CompactValue.Buffer nmargin(long struct) {
        return CompactValue.create(struct + (long)MARGIN, 9);
    }

    public static CompactValue nmargin(long struct, int index) {
        return CompactValue.create(struct + (long)MARGIN + Checks.check((int)index, (int)9) * (long)CompactValue.SIZEOF);
    }

    public static CompactValue.Buffer npositions(long struct) {
        return CompactValue.create(struct + (long)POSITIONS, 9);
    }

    public static CompactValue npositions(long struct, int index) {
        return CompactValue.create(struct + (long)POSITIONS + Checks.check((int)index, (int)9) * (long)CompactValue.SIZEOF);
    }

    public static CompactValue.Buffer npadding(long struct) {
        return CompactValue.create(struct + (long)PADDING, 9);
    }

    public static CompactValue npadding(long struct, int index) {
        return CompactValue.create(struct + (long)PADDING + Checks.check((int)index, (int)9) * (long)CompactValue.SIZEOF);
    }

    public static CompactValue.Buffer nborder(long struct) {
        return CompactValue.create(struct + (long)BORDER, 9);
    }

    public static CompactValue nborder(long struct, int index) {
        return CompactValue.create(struct + (long)BORDER + Checks.check((int)index, (int)9) * (long)CompactValue.SIZEOF);
    }

    public static CompactValue.Buffer ndimensions(long struct) {
        return CompactValue.create(struct + (long)DIMENSIONS, 2);
    }

    public static CompactValue ndimensions(long struct, int index) {
        return CompactValue.create(struct + (long)DIMENSIONS + Checks.check((int)index, (int)2) * (long)CompactValue.SIZEOF);
    }

    public static CompactValue.Buffer nminDimensions(long struct) {
        return CompactValue.create(struct + (long)MINDIMENSIONS, 2);
    }

    public static CompactValue nminDimensions(long struct, int index) {
        return CompactValue.create(struct + (long)MINDIMENSIONS + Checks.check((int)index, (int)2) * (long)CompactValue.SIZEOF);
    }

    public static CompactValue.Buffer nmaxDimensions(long struct) {
        return CompactValue.create(struct + (long)MAXDIMENSIONS, 2);
    }

    public static CompactValue nmaxDimensions(long struct, int index) {
        return CompactValue.create(struct + (long)MAXDIMENSIONS + Checks.check((int)index, (int)2) * (long)CompactValue.SIZEOF);
    }

    public static YGFloatOptional naspectRatio(long struct) {
        return YGFloatOptional.create(struct + (long)ASPECTRATIO);
    }

    static {
        LibYoga.initialize();
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer offsets = stack.mallocInt(13);
            SIZEOF = YGStyle.offsets(MemoryUtil.memAddress((IntBuffer)offsets));
            FLEX = offsets.get(0);
            FLEXGROW = offsets.get(1);
            FLEXSHRINK = offsets.get(2);
            FLEXBASIS = offsets.get(3);
            MARGIN = offsets.get(4);
            POSITIONS = offsets.get(5);
            PADDING = offsets.get(6);
            BORDER = offsets.get(7);
            DIMENSIONS = offsets.get(8);
            MINDIMENSIONS = offsets.get(9);
            MAXDIMENSIONS = offsets.get(10);
            ASPECTRATIO = offsets.get(11);
            ALIGNOF = offsets.get(12);
        }
    }

    public static class Buffer
    extends StructBuffer<YGStyle, Buffer> {
        private static final YGStyle ELEMENT_FACTORY = YGStyle.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected YGStyle getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="YGDirection")
        public int direction() {
            return YGStyle.ndirection(this.address());
        }

        @NativeType(value="YGFlexDirection")
        public int flexDirection() {
            return YGStyle.nflexDirection(this.address());
        }

        @NativeType(value="YGJustify")
        public int justifyContent() {
            return YGStyle.njustifyContent(this.address());
        }

        @NativeType(value="YGAlign")
        public int alignContent() {
            return YGStyle.nalignContent(this.address());
        }

        @NativeType(value="YGAlign")
        public int alignItems() {
            return YGStyle.nalignItems(this.address());
        }

        @NativeType(value="YGAlign")
        public int alignSelf() {
            return YGStyle.nalignSelf(this.address());
        }

        @NativeType(value="YGPositionType")
        public int positionType() {
            return YGStyle.npositionType(this.address());
        }

        @NativeType(value="YGWrap")
        public int flexWrap() {
            return YGStyle.nflexWrap(this.address());
        }

        @NativeType(value="YGOverflow")
        public int overflow() {
            return YGStyle.noverflow(this.address());
        }

        @NativeType(value="YGDisplay")
        public int display() {
            return YGStyle.ndisplay(this.address());
        }

        public YGFloatOptional flex() {
            return YGStyle.nflex(this.address());
        }

        public YGFloatOptional flexGrow() {
            return YGStyle.nflexGrow(this.address());
        }

        public YGFloatOptional flexShrink() {
            return YGStyle.nflexShrink(this.address());
        }

        public CompactValue flexBasis() {
            return YGStyle.nflexBasis(this.address());
        }

        @NativeType(value="CompactValue[9]")
        public CompactValue.Buffer margin() {
            return YGStyle.nmargin(this.address());
        }

        public CompactValue margin(int index) {
            return YGStyle.nmargin(this.address(), index);
        }

        @NativeType(value="CompactValue[9]")
        public CompactValue.Buffer positions() {
            return YGStyle.npositions(this.address());
        }

        public CompactValue positions(int index) {
            return YGStyle.npositions(this.address(), index);
        }

        @NativeType(value="CompactValue[9]")
        public CompactValue.Buffer padding() {
            return YGStyle.npadding(this.address());
        }

        public CompactValue padding(int index) {
            return YGStyle.npadding(this.address(), index);
        }

        @NativeType(value="CompactValue[9]")
        public CompactValue.Buffer border() {
            return YGStyle.nborder(this.address());
        }

        public CompactValue border(int index) {
            return YGStyle.nborder(this.address(), index);
        }

        @NativeType(value="CompactValue[2]")
        public CompactValue.Buffer dimensions() {
            return YGStyle.ndimensions(this.address());
        }

        public CompactValue dimensions(int index) {
            return YGStyle.ndimensions(this.address(), index);
        }

        @NativeType(value="CompactValue[2]")
        public CompactValue.Buffer minDimensions() {
            return YGStyle.nminDimensions(this.address());
        }

        public CompactValue minDimensions(int index) {
            return YGStyle.nminDimensions(this.address(), index);
        }

        @NativeType(value="CompactValue[2]")
        public CompactValue.Buffer maxDimensions() {
            return YGStyle.nmaxDimensions(this.address());
        }

        public CompactValue maxDimensions(int index) {
            return YGStyle.nmaxDimensions(this.address(), index);
        }

        public YGFloatOptional aspectRatio() {
            return YGStyle.naspectRatio(this.address());
        }
    }
}

