/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.yoga;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.yoga.LibYoga;
import org.lwjgl.util.yoga.YGBaselineFunc;
import org.lwjgl.util.yoga.YGBaselineFuncI;
import org.lwjgl.util.yoga.YGDirtiedFunc;
import org.lwjgl.util.yoga.YGDirtiedFuncI;
import org.lwjgl.util.yoga.YGLayout;
import org.lwjgl.util.yoga.YGMeasureFunc;
import org.lwjgl.util.yoga.YGMeasureFuncI;
import org.lwjgl.util.yoga.YGPrintFunc;
import org.lwjgl.util.yoga.YGPrintFuncI;
import org.lwjgl.util.yoga.YGStyle;
import org.lwjgl.util.yoga.YGValue;

@NativeType(value="struct YGNodeLWJGL")
public class YGNode
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CONTEXT;
    public static final int MEASURE;
    public static final int MEASURE_NOCONTEXT;
    public static final int MEASURE_WITHCONTEXT;
    public static final int BASELINE;
    public static final int BASELINE_NOCONTEXT;
    public static final int BASELINE_WITHCONTEXT;
    public static final int PRINT;
    public static final int PRINT_NOCONTEXT;
    public static final int PRINT_WITHCONTEXT;
    public static final int DIRTIED;
    public static final int STYLE;
    public static final int LAYOUT;
    public static final int LINEINDEX;
    public static final int OWNER;
    public static final int CHILDREN;
    public static final int CONFIG;
    public static final int RESOLVEDDIMENSIONS;

    private static native int offsets(long var0);

    public YGNode(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), YGNode.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public long context() {
        return YGNode.ncontext(this.address());
    }

    @NativeType(value="bool")
    public boolean hasNewLayout() {
        return YGNode.nhasNewLayout(this.address());
    }

    @NativeType(value="bool")
    public boolean isReferenceBaseline() {
        return YGNode.nisReferenceBaseline(this.address());
    }

    @NativeType(value="bool")
    public boolean isDirty() {
        return YGNode.nisDirty(this.address());
    }

    @NativeType(value="YGNodeType")
    public int nodeType() {
        return YGNode.nnodeType(this.address());
    }

    @NativeType(value="bool")
    public boolean measureUsesContext() {
        return YGNode.nmeasureUsesContext(this.address());
    }

    @NativeType(value="bool")
    public boolean baselineUsesContext() {
        return YGNode.nbaselineUsesContext(this.address());
    }

    @NativeType(value="bool")
    public boolean printUsesContext() {
        return YGNode.nprintUsesContext(this.address());
    }

    @Nullable
    public YGMeasureFunc measure_noContext() {
        return YGNode.nmeasure_noContext(this.address());
    }

    @NativeType(value="MeasureWithContextFn")
    public long measure_withContext() {
        return YGNode.nmeasure_withContext(this.address());
    }

    @Nullable
    public YGBaselineFunc baseline_noContext() {
        return YGNode.nbaseline_noContext(this.address());
    }

    @NativeType(value="BaselineWithContextFn")
    public long baseline_withContext() {
        return YGNode.nbaseline_withContext(this.address());
    }

    @Nullable
    public YGPrintFunc print_noContext() {
        return YGNode.nprint_noContext(this.address());
    }

    @NativeType(value="PrintWithContextFn")
    public long print_withContext() {
        return YGNode.nprint_withContext(this.address());
    }

    @Nullable
    public YGDirtiedFunc dirtied() {
        return YGNode.ndirtied(this.address());
    }

    public YGStyle style() {
        return YGNode.nstyle(this.address());
    }

    public YGLayout layout() {
        return YGNode.nlayout(this.address());
    }

    @NativeType(value="uint32_t")
    public int lineIndex() {
        return YGNode.nlineIndex(this.address());
    }

    @NativeType(value="YGNodeRef")
    public long owner() {
        return YGNode.nowner(this.address());
    }

    @NativeType(value="YGConfigRef")
    public long config() {
        return YGNode.nconfig(this.address());
    }

    @NativeType(value="YGValue[2]")
    public YGValue.Buffer resolvedDimensions() {
        return YGNode.nresolvedDimensions(this.address());
    }

    public YGValue resolvedDimensions(int index) {
        return YGNode.nresolvedDimensions(this.address(), index);
    }

    public YGNode context(@NativeType(value="void *") long value) {
        YGNode.ncontext(this.address(), value);
        return this;
    }

    public YGNode hasNewLayout(@NativeType(value="bool") boolean value) {
        YGNode.nhasNewLayout(this.address(), value);
        return this;
    }

    public YGNode isReferenceBaseline(@NativeType(value="bool") boolean value) {
        YGNode.nisReferenceBaseline(this.address(), value);
        return this;
    }

    public YGNode isDirty(@NativeType(value="bool") boolean value) {
        YGNode.nisDirty(this.address(), value);
        return this;
    }

    public YGNode nodeType(@NativeType(value="YGNodeType") int value) {
        YGNode.nnodeType(this.address(), value);
        return this;
    }

    public YGNode measureUsesContext(@NativeType(value="bool") boolean value) {
        YGNode.nmeasureUsesContext(this.address(), value);
        return this;
    }

    public YGNode baselineUsesContext(@NativeType(value="bool") boolean value) {
        YGNode.nbaselineUsesContext(this.address(), value);
        return this;
    }

    public YGNode printUsesContext(@NativeType(value="bool") boolean value) {
        YGNode.nprintUsesContext(this.address(), value);
        return this;
    }

    public YGNode measure_noContext(@Nullable @NativeType(value="YGMeasureFunc") YGMeasureFuncI value) {
        YGNode.nmeasure_noContext(this.address(), value);
        return this;
    }

    public YGNode measure_withContext(@NativeType(value="MeasureWithContextFn") long value) {
        YGNode.nmeasure_withContext(this.address(), value);
        return this;
    }

    public YGNode baseline_noContext(@Nullable @NativeType(value="YGBaselineFunc") YGBaselineFuncI value) {
        YGNode.nbaseline_noContext(this.address(), value);
        return this;
    }

    public YGNode baseline_withContext(@NativeType(value="BaselineWithContextFn") long value) {
        YGNode.nbaseline_withContext(this.address(), value);
        return this;
    }

    public YGNode print_noContext(@Nullable @NativeType(value="YGPrintFunc") YGPrintFuncI value) {
        YGNode.nprint_noContext(this.address(), value);
        return this;
    }

    public YGNode print_withContext(@NativeType(value="PrintWithContextFn") long value) {
        YGNode.nprint_withContext(this.address(), value);
        return this;
    }

    public YGNode dirtied(@Nullable @NativeType(value="YGDirtiedFunc") YGDirtiedFuncI value) {
        YGNode.ndirtied(this.address(), value);
        return this;
    }

    public YGNode style(YGStyle value) {
        YGNode.nstyle(this.address(), value);
        return this;
    }

    public YGNode layout(YGLayout value) {
        YGNode.nlayout(this.address(), value);
        return this;
    }

    public YGNode lineIndex(@NativeType(value="uint32_t") int value) {
        YGNode.nlineIndex(this.address(), value);
        return this;
    }

    public YGNode owner(@NativeType(value="YGNodeRef") long value) {
        YGNode.nowner(this.address(), value);
        return this;
    }

    public YGNode config(@NativeType(value="YGConfigRef") long value) {
        YGNode.nconfig(this.address(), value);
        return this;
    }

    public YGNode resolvedDimensions(@NativeType(value="YGValue[2]") YGValue.Buffer value) {
        YGNode.nresolvedDimensions(this.address(), value);
        return this;
    }

    public YGNode resolvedDimensions(int index, YGValue value) {
        YGNode.nresolvedDimensions(this.address(), index, value);
        return this;
    }

    public YGNode set(YGNode src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static YGNode malloc() {
        return (YGNode)YGNode.wrap(YGNode.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static YGNode calloc() {
        return (YGNode)YGNode.wrap(YGNode.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static YGNode create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (YGNode)YGNode.wrap(YGNode.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static YGNode create(long address) {
        return (YGNode)YGNode.wrap(YGNode.class, (long)address);
    }

    @Nullable
    public static YGNode createSafe(long address) {
        return address == 0L ? null : (YGNode)YGNode.wrap(YGNode.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)YGNode.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)YGNode.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)YGNode.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = YGNode.__create((int)capacity, (int)SIZEOF);
        return (Buffer)YGNode.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)YGNode.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)YGNode.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static YGNode mallocStack() {
        return YGNode.mallocStack(MemoryStack.stackGet());
    }

    public static YGNode callocStack() {
        return YGNode.callocStack(MemoryStack.stackGet());
    }

    public static YGNode mallocStack(MemoryStack stack) {
        return (YGNode)YGNode.wrap(YGNode.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static YGNode callocStack(MemoryStack stack) {
        return (YGNode)YGNode.wrap(YGNode.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return YGNode.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return YGNode.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)YGNode.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)YGNode.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long ncontext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)CONTEXT));
    }

    public static native boolean nhasNewLayout(long var0);

    public static native boolean nisReferenceBaseline(long var0);

    public static native boolean nisDirty(long var0);

    public static native int nnodeType(long var0);

    public static native boolean nmeasureUsesContext(long var0);

    public static native boolean nbaselineUsesContext(long var0);

    public static native boolean nprintUsesContext(long var0);

    @Nullable
    public static YGMeasureFunc nmeasure_noContext(long struct) {
        return YGMeasureFunc.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)MEASURE_NOCONTEXT)));
    }

    public static long nmeasure_withContext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)MEASURE_WITHCONTEXT));
    }

    @Nullable
    public static YGBaselineFunc nbaseline_noContext(long struct) {
        return YGBaselineFunc.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)BASELINE_NOCONTEXT)));
    }

    public static long nbaseline_withContext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)BASELINE_WITHCONTEXT));
    }

    @Nullable
    public static YGPrintFunc nprint_noContext(long struct) {
        return YGPrintFunc.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PRINT_NOCONTEXT)));
    }

    public static long nprint_withContext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PRINT_WITHCONTEXT));
    }

    @Nullable
    public static YGDirtiedFunc ndirtied(long struct) {
        return YGDirtiedFunc.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)DIRTIED)));
    }

    public static YGStyle nstyle(long struct) {
        return YGStyle.create(struct + (long)STYLE);
    }

    public static YGLayout nlayout(long struct) {
        return YGLayout.create(struct + (long)LAYOUT);
    }

    public static int nlineIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)LINEINDEX);
    }

    public static long nowner(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)OWNER));
    }

    public static long nchildren(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)CHILDREN));
    }

    public static long nconfig(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)CONFIG));
    }

    public static YGValue.Buffer nresolvedDimensions(long struct) {
        return YGValue.create(struct + (long)RESOLVEDDIMENSIONS, 2);
    }

    public static YGValue nresolvedDimensions(long struct, int index) {
        return YGValue.create(struct + (long)RESOLVEDDIMENSIONS + Checks.check((int)index, (int)2) * (long)YGValue.SIZEOF);
    }

    public static void ncontext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CONTEXT), (long)value);
    }

    public static native void nhasNewLayout(long var0, boolean var2);

    public static native void nisReferenceBaseline(long var0, boolean var2);

    public static native void nisDirty(long var0, boolean var2);

    public static native void nnodeType(long var0, int var2);

    public static native void nmeasureUsesContext(long var0, boolean var2);

    public static native void nbaselineUsesContext(long var0, boolean var2);

    public static native void nprintUsesContext(long var0, boolean var2);

    public static void nmeasure_noContext(long struct, @Nullable YGMeasureFuncI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MEASURE_NOCONTEXT), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nmeasure_withContext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MEASURE_WITHCONTEXT), (long)value);
    }

    public static void nbaseline_noContext(long struct, @Nullable YGBaselineFuncI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)BASELINE_NOCONTEXT), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nbaseline_withContext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)BASELINE_WITHCONTEXT), (long)value);
    }

    public static void nprint_noContext(long struct, @Nullable YGPrintFuncI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PRINT_NOCONTEXT), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nprint_withContext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PRINT_WITHCONTEXT), (long)value);
    }

    public static void ndirtied(long struct, @Nullable YGDirtiedFuncI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DIRTIED), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nstyle(long struct, YGStyle value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)STYLE), (long)YGStyle.SIZEOF);
    }

    public static void nlayout(long struct, YGLayout value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)LAYOUT), (long)YGLayout.SIZEOF);
    }

    public static void nlineIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LINEINDEX, value);
    }

    public static void nowner(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)OWNER), (long)value);
    }

    public static void nchildren(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CHILDREN), (long)value);
    }

    public static void nconfig(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CONFIG), (long)value);
    }

    public static void nresolvedDimensions(long struct, YGValue.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((CustomBuffer)value, (int)2);
        }
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)RESOLVEDDIMENSIONS), (long)(value.remaining() * YGValue.SIZEOF));
    }

    public static void nresolvedDimensions(long struct, int index, YGValue value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)RESOLVEDDIMENSIONS + Checks.check((int)index, (int)2) * (long)YGValue.SIZEOF), (long)YGValue.SIZEOF);
    }

    static {
        LibYoga.initialize();
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer offsets = stack.mallocInt(19);
            SIZEOF = YGNode.offsets(MemoryUtil.memAddress((IntBuffer)offsets));
            CONTEXT = offsets.get(0);
            MEASURE = offsets.get(1);
            MEASURE_NOCONTEXT = offsets.get(2);
            MEASURE_WITHCONTEXT = offsets.get(3);
            BASELINE = offsets.get(4);
            BASELINE_NOCONTEXT = offsets.get(5);
            BASELINE_WITHCONTEXT = offsets.get(6);
            PRINT = offsets.get(7);
            PRINT_NOCONTEXT = offsets.get(8);
            PRINT_WITHCONTEXT = offsets.get(9);
            DIRTIED = offsets.get(10);
            STYLE = offsets.get(11);
            LAYOUT = offsets.get(12);
            LINEINDEX = offsets.get(13);
            OWNER = offsets.get(14);
            CHILDREN = offsets.get(15);
            CONFIG = offsets.get(16);
            RESOLVEDDIMENSIONS = offsets.get(17);
            ALIGNOF = offsets.get(18);
        }
    }

    public static class Buffer
    extends StructBuffer<YGNode, Buffer>
    implements NativeResource {
        private static final YGNode ELEMENT_FACTORY = YGNode.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected YGNode getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public long context() {
            return YGNode.ncontext(this.address());
        }

        @NativeType(value="bool")
        public boolean hasNewLayout() {
            return YGNode.nhasNewLayout(this.address());
        }

        @NativeType(value="bool")
        public boolean isReferenceBaseline() {
            return YGNode.nisReferenceBaseline(this.address());
        }

        @NativeType(value="bool")
        public boolean isDirty() {
            return YGNode.nisDirty(this.address());
        }

        @NativeType(value="YGNodeType")
        public int nodeType() {
            return YGNode.nnodeType(this.address());
        }

        @NativeType(value="bool")
        public boolean measureUsesContext() {
            return YGNode.nmeasureUsesContext(this.address());
        }

        @NativeType(value="bool")
        public boolean baselineUsesContext() {
            return YGNode.nbaselineUsesContext(this.address());
        }

        @NativeType(value="bool")
        public boolean printUsesContext() {
            return YGNode.nprintUsesContext(this.address());
        }

        @Nullable
        public YGMeasureFunc measure_noContext() {
            return YGNode.nmeasure_noContext(this.address());
        }

        @NativeType(value="MeasureWithContextFn")
        public long measure_withContext() {
            return YGNode.nmeasure_withContext(this.address());
        }

        @Nullable
        public YGBaselineFunc baseline_noContext() {
            return YGNode.nbaseline_noContext(this.address());
        }

        @NativeType(value="BaselineWithContextFn")
        public long baseline_withContext() {
            return YGNode.nbaseline_withContext(this.address());
        }

        @Nullable
        public YGPrintFunc print_noContext() {
            return YGNode.nprint_noContext(this.address());
        }

        @NativeType(value="PrintWithContextFn")
        public long print_withContext() {
            return YGNode.nprint_withContext(this.address());
        }

        @Nullable
        public YGDirtiedFunc dirtied() {
            return YGNode.ndirtied(this.address());
        }

        public YGStyle style() {
            return YGNode.nstyle(this.address());
        }

        public YGLayout layout() {
            return YGNode.nlayout(this.address());
        }

        @NativeType(value="uint32_t")
        public int lineIndex() {
            return YGNode.nlineIndex(this.address());
        }

        @NativeType(value="YGNodeRef")
        public long owner() {
            return YGNode.nowner(this.address());
        }

        @NativeType(value="YGConfigRef")
        public long config() {
            return YGNode.nconfig(this.address());
        }

        @NativeType(value="YGValue[2]")
        public YGValue.Buffer resolvedDimensions() {
            return YGNode.nresolvedDimensions(this.address());
        }

        public YGValue resolvedDimensions(int index) {
            return YGNode.nresolvedDimensions(this.address(), index);
        }

        public Buffer context(@NativeType(value="void *") long value) {
            YGNode.ncontext(this.address(), value);
            return this;
        }

        public Buffer hasNewLayout(@NativeType(value="bool") boolean value) {
            YGNode.nhasNewLayout(this.address(), value);
            return this;
        }

        public Buffer isReferenceBaseline(@NativeType(value="bool") boolean value) {
            YGNode.nisReferenceBaseline(this.address(), value);
            return this;
        }

        public Buffer isDirty(@NativeType(value="bool") boolean value) {
            YGNode.nisDirty(this.address(), value);
            return this;
        }

        public Buffer nodeType(@NativeType(value="YGNodeType") int value) {
            YGNode.nnodeType(this.address(), value);
            return this;
        }

        public Buffer measureUsesContext(@NativeType(value="bool") boolean value) {
            YGNode.nmeasureUsesContext(this.address(), value);
            return this;
        }

        public Buffer baselineUsesContext(@NativeType(value="bool") boolean value) {
            YGNode.nbaselineUsesContext(this.address(), value);
            return this;
        }

        public Buffer printUsesContext(@NativeType(value="bool") boolean value) {
            YGNode.nprintUsesContext(this.address(), value);
            return this;
        }

        public Buffer measure_noContext(@Nullable @NativeType(value="YGMeasureFunc") YGMeasureFuncI value) {
            YGNode.nmeasure_noContext(this.address(), value);
            return this;
        }

        public Buffer measure_withContext(@NativeType(value="MeasureWithContextFn") long value) {
            YGNode.nmeasure_withContext(this.address(), value);
            return this;
        }

        public Buffer baseline_noContext(@Nullable @NativeType(value="YGBaselineFunc") YGBaselineFuncI value) {
            YGNode.nbaseline_noContext(this.address(), value);
            return this;
        }

        public Buffer baseline_withContext(@NativeType(value="BaselineWithContextFn") long value) {
            YGNode.nbaseline_withContext(this.address(), value);
            return this;
        }

        public Buffer print_noContext(@Nullable @NativeType(value="YGPrintFunc") YGPrintFuncI value) {
            YGNode.nprint_noContext(this.address(), value);
            return this;
        }

        public Buffer print_withContext(@NativeType(value="PrintWithContextFn") long value) {
            YGNode.nprint_withContext(this.address(), value);
            return this;
        }

        public Buffer dirtied(@Nullable @NativeType(value="YGDirtiedFunc") YGDirtiedFuncI value) {
            YGNode.ndirtied(this.address(), value);
            return this;
        }

        public Buffer style(YGStyle value) {
            YGNode.nstyle(this.address(), value);
            return this;
        }

        public Buffer layout(YGLayout value) {
            YGNode.nlayout(this.address(), value);
            return this;
        }

        public Buffer lineIndex(@NativeType(value="uint32_t") int value) {
            YGNode.nlineIndex(this.address(), value);
            return this;
        }

        public Buffer owner(@NativeType(value="YGNodeRef") long value) {
            YGNode.nowner(this.address(), value);
            return this;
        }

        public Buffer config(@NativeType(value="YGConfigRef") long value) {
            YGNode.nconfig(this.address(), value);
            return this;
        }

        public Buffer resolvedDimensions(@NativeType(value="YGValue[2]") YGValue.Buffer value) {
            YGNode.nresolvedDimensions(this.address(), value);
            return this;
        }

        public Buffer resolvedDimensions(int index, YGValue value) {
            YGNode.nresolvedDimensions(this.address(), index, value);
            return this;
        }
    }
}

