/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.yoga;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class YGMarkerLayoutData
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LAYOUTS;
    public static final int MEASURES;
    public static final int MAXMEASURECACHE;
    public static final int CACHEDLAYOUTS;
    public static final int CACHEDMEASURES;

    public YGMarkerLayoutData(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), YGMarkerLayoutData.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int layouts() {
        return YGMarkerLayoutData.nlayouts(this.address());
    }

    public int measures() {
        return YGMarkerLayoutData.nmeasures(this.address());
    }

    public int maxMeasureCache() {
        return YGMarkerLayoutData.nmaxMeasureCache(this.address());
    }

    public int cachedLayouts() {
        return YGMarkerLayoutData.ncachedLayouts(this.address());
    }

    public int cachedMeasures() {
        return YGMarkerLayoutData.ncachedMeasures(this.address());
    }

    public static YGMarkerLayoutData create(long address) {
        return (YGMarkerLayoutData)YGMarkerLayoutData.wrap(YGMarkerLayoutData.class, (long)address);
    }

    @Nullable
    public static YGMarkerLayoutData createSafe(long address) {
        return address == 0L ? null : (YGMarkerLayoutData)YGMarkerLayoutData.wrap(YGMarkerLayoutData.class, (long)address);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)YGMarkerLayoutData.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)YGMarkerLayoutData.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static int nlayouts(long struct) {
        return UNSAFE.getInt(null, struct + (long)LAYOUTS);
    }

    public static int nmeasures(long struct) {
        return UNSAFE.getInt(null, struct + (long)MEASURES);
    }

    public static int nmaxMeasureCache(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXMEASURECACHE);
    }

    public static int ncachedLayouts(long struct) {
        return UNSAFE.getInt(null, struct + (long)CACHEDLAYOUTS);
    }

    public static int ncachedMeasures(long struct) {
        return UNSAFE.getInt(null, struct + (long)CACHEDMEASURES);
    }

    static {
        Struct.Layout layout = YGMarkerLayoutData.__struct((Struct.Member[])new Struct.Member[]{YGMarkerLayoutData.__member((int)4), YGMarkerLayoutData.__member((int)4), YGMarkerLayoutData.__member((int)4), YGMarkerLayoutData.__member((int)4), YGMarkerLayoutData.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LAYOUTS = layout.offsetof(0);
        MEASURES = layout.offsetof(1);
        MAXMEASURECACHE = layout.offsetof(2);
        CACHEDLAYOUTS = layout.offsetof(3);
        CACHEDMEASURES = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<YGMarkerLayoutData, Buffer> {
        private static final YGMarkerLayoutData ELEMENT_FACTORY = YGMarkerLayoutData.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected YGMarkerLayoutData getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int layouts() {
            return YGMarkerLayoutData.nlayouts(this.address());
        }

        public int measures() {
            return YGMarkerLayoutData.nmeasures(this.address());
        }

        public int maxMeasureCache() {
            return YGMarkerLayoutData.nmaxMeasureCache(this.address());
        }

        public int cachedLayouts() {
            return YGMarkerLayoutData.ncachedLayouts(this.address());
        }

        public int cachedMeasures() {
            return YGMarkerLayoutData.ncachedMeasures(this.address());
        }
    }
}

