/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.yoga;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.yoga.YGMarkerLayoutData;
import org.lwjgl.util.yoga.YGMarkerNoData;

public class YGMarkerData
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LAYOUT;
    public static final int NODATA;

    public YGMarkerData(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), YGMarkerData.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="YGMarkerLayoutData *")
    public YGMarkerLayoutData layout() {
        return YGMarkerData.nlayout(this.address());
    }

    @NativeType(value="YGMarkerNoData *")
    public YGMarkerNoData noData() {
        return YGMarkerData.nnoData(this.address());
    }

    public static YGMarkerData create(long address) {
        return (YGMarkerData)YGMarkerData.wrap(YGMarkerData.class, (long)address);
    }

    @Nullable
    public static YGMarkerData createSafe(long address) {
        return address == 0L ? null : (YGMarkerData)YGMarkerData.wrap(YGMarkerData.class, (long)address);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)YGMarkerData.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)YGMarkerData.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static YGMarkerLayoutData nlayout(long struct) {
        return YGMarkerLayoutData.create(MemoryUtil.memGetAddress((long)(struct + (long)LAYOUT)));
    }

    public static YGMarkerNoData nnoData(long struct) {
        return YGMarkerNoData.create(MemoryUtil.memGetAddress((long)(struct + (long)NODATA)));
    }

    static {
        Struct.Layout layout = YGMarkerData.__union((Struct.Member[])new Struct.Member[]{YGMarkerData.__member((int)POINTER_SIZE), YGMarkerData.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LAYOUT = layout.offsetof(0);
        NODATA = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<YGMarkerData, Buffer> {
        private static final YGMarkerData ELEMENT_FACTORY = YGMarkerData.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected YGMarkerData getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="YGMarkerLayoutData *")
        public YGMarkerLayoutData layout() {
            return YGMarkerData.nlayout(this.address());
        }

        @NativeType(value="YGMarkerNoData *")
        public YGMarkerNoData noData() {
            return YGMarkerData.nnoData(this.address());
        }
    }
}

