/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.yoga;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.yoga.EndMarkerCallback;
import org.lwjgl.util.yoga.EndMarkerCallbackI;
import org.lwjgl.util.yoga.StartMarkerCallback;
import org.lwjgl.util.yoga.StartMarkerCallbackI;

public class YGMarkerCallbacks
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STARTMARKER;
    public static final int ENDMARKER;

    public YGMarkerCallbacks(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), YGMarkerCallbacks.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @Nullable
    @NativeType(value="void * (*) (YGMarker, YGNodeRef, void *)")
    public StartMarkerCallback startMarker() {
        return YGMarkerCallbacks.nstartMarker(this.address());
    }

    @Nullable
    @NativeType(value="void (*) (YGMarker, YGNodeRef, void *, void *)")
    public EndMarkerCallback endMarker() {
        return YGMarkerCallbacks.nendMarker(this.address());
    }

    public YGMarkerCallbacks startMarker(@Nullable @NativeType(value="void * (*) (YGMarker, YGNodeRef, void *)") StartMarkerCallbackI value) {
        YGMarkerCallbacks.nstartMarker(this.address(), value);
        return this;
    }

    public YGMarkerCallbacks endMarker(@Nullable @NativeType(value="void (*) (YGMarker, YGNodeRef, void *, void *)") EndMarkerCallbackI value) {
        YGMarkerCallbacks.nendMarker(this.address(), value);
        return this;
    }

    public YGMarkerCallbacks set(StartMarkerCallbackI startMarker, EndMarkerCallbackI endMarker) {
        this.startMarker(startMarker);
        this.endMarker(endMarker);
        return this;
    }

    public YGMarkerCallbacks set(YGMarkerCallbacks src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static YGMarkerCallbacks malloc() {
        return (YGMarkerCallbacks)YGMarkerCallbacks.wrap(YGMarkerCallbacks.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static YGMarkerCallbacks calloc() {
        return (YGMarkerCallbacks)YGMarkerCallbacks.wrap(YGMarkerCallbacks.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static YGMarkerCallbacks create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (YGMarkerCallbacks)YGMarkerCallbacks.wrap(YGMarkerCallbacks.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static YGMarkerCallbacks create(long address) {
        return (YGMarkerCallbacks)YGMarkerCallbacks.wrap(YGMarkerCallbacks.class, (long)address);
    }

    @Nullable
    public static YGMarkerCallbacks createSafe(long address) {
        return address == 0L ? null : (YGMarkerCallbacks)YGMarkerCallbacks.wrap(YGMarkerCallbacks.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)YGMarkerCallbacks.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)YGMarkerCallbacks.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)YGMarkerCallbacks.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = YGMarkerCallbacks.__create((int)capacity, (int)SIZEOF);
        return (Buffer)YGMarkerCallbacks.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)YGMarkerCallbacks.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)YGMarkerCallbacks.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static YGMarkerCallbacks mallocStack() {
        return YGMarkerCallbacks.mallocStack(MemoryStack.stackGet());
    }

    public static YGMarkerCallbacks callocStack() {
        return YGMarkerCallbacks.callocStack(MemoryStack.stackGet());
    }

    public static YGMarkerCallbacks mallocStack(MemoryStack stack) {
        return (YGMarkerCallbacks)YGMarkerCallbacks.wrap(YGMarkerCallbacks.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static YGMarkerCallbacks callocStack(MemoryStack stack) {
        return (YGMarkerCallbacks)YGMarkerCallbacks.wrap(YGMarkerCallbacks.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return YGMarkerCallbacks.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return YGMarkerCallbacks.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)YGMarkerCallbacks.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)YGMarkerCallbacks.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    @Nullable
    public static StartMarkerCallback nstartMarker(long struct) {
        return StartMarkerCallback.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)STARTMARKER)));
    }

    @Nullable
    public static EndMarkerCallback nendMarker(long struct) {
        return EndMarkerCallback.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)ENDMARKER)));
    }

    public static void nstartMarker(long struct, @Nullable StartMarkerCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)STARTMARKER), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nendMarker(long struct, @Nullable EndMarkerCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)ENDMARKER), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    static {
        Struct.Layout layout = YGMarkerCallbacks.__struct((Struct.Member[])new Struct.Member[]{YGMarkerCallbacks.__member((int)POINTER_SIZE), YGMarkerCallbacks.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STARTMARKER = layout.offsetof(0);
        ENDMARKER = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<YGMarkerCallbacks, Buffer>
    implements NativeResource {
        private static final YGMarkerCallbacks ELEMENT_FACTORY = YGMarkerCallbacks.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected YGMarkerCallbacks getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Nullable
        @NativeType(value="void * (*) (YGMarker, YGNodeRef, void *)")
        public StartMarkerCallback startMarker() {
            return YGMarkerCallbacks.nstartMarker(this.address());
        }

        @Nullable
        @NativeType(value="void (*) (YGMarker, YGNodeRef, void *, void *)")
        public EndMarkerCallback endMarker() {
            return YGMarkerCallbacks.nendMarker(this.address());
        }

        public Buffer startMarker(@Nullable @NativeType(value="void * (*) (YGMarker, YGNodeRef, void *)") StartMarkerCallbackI value) {
            YGMarkerCallbacks.nstartMarker(this.address(), value);
            return this;
        }

        public Buffer endMarker(@Nullable @NativeType(value="void (*) (YGMarker, YGNodeRef, void *, void *)") EndMarkerCallbackI value) {
            YGMarkerCallbacks.nendMarker(this.address(), value);
            return this;
        }
    }
}

