/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.connector.client.gui.guild;

import com.craftingdead.immerse.client.gui.screen.Theme;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.rocketpowered.common.Guild;
import net.rocketpowered.common.GuildMember;
import net.rocketpowered.common.GuildMemberUpdateEvent;
import net.rocketpowered.common.GuildPermission;
import net.rocketpowered.common.RocketException;
import net.rocketpowered.connector.client.gui.RocketToast;
import net.rocketpowered.connector.client.gui.guild.ConfirmDialogView;
import net.rocketpowered.connector.client.gui.guild.MemberView;
import net.rocketpowered.connector.client.gui.guild.TextDialogView;
import net.rocketpowered.sdk.Rocket;
import net.rocketpowered.sdk.interf.GameClientInterface;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import sm0keysa1m0n.bliss.view.ParentView;
import sm0keysa1m0n.bliss.view.TextView;
import sm0keysa1m0n.bliss.view.View;
import sm0keysa1m0n.bliss.view.event.RemovedEvent;

public class YourGuildView
extends ParentView {
    public static final Component TITLE = new TranslatableComponent("view.guild.your_guild");
    private final ParentView informationView;
    private final ParentView membersView;
    private final Map<ObjectId, MemberView> memberViews = new HashMap<ObjectId, MemberView>();
    private final Consumer<View> contentConsumer;
    private final View transferButton;
    private final View deleteButton;
    private final View renameButton;
    private final View leaveButton;
    @Nullable
    private Guild guild;
    private Disposable listener;
    @Nullable
    private GuildMember selfMember;

    public YourGuildView(Consumer<View> contentConsumer) {
        super(new View.Properties().styleClasses("page", "blur"));
        this.contentConsumer = contentConsumer;
        this.addChild(new TextView(new View.Properties().id("title")).setText((FormattedText)TITLE));
        ParentView guildView = new ParentView(new View.Properties().id("guild"));
        this.addChild(guildView);
        this.informationView = new ParentView(new View.Properties().id("information"));
        guildView.addChild(this.informationView);
        this.membersView = new ParentView(new View.Properties().id("members"));
        guildView.addChild(this.membersView);
        this.transferButton = Theme.createRedButton((Component)new TextComponent("Transfer"), () -> this.contentConsumer.accept(new TextDialogView((Component)new TranslatableComponent("view.guild.your_guild.transfer.message"), I18n.m_118938_((String)"view.guild.text_dialog.username", (Object[])new Object[0]), result -> {
            Rocket.gameClientInterface().ifPresent(gateway -> gateway.getUserId(result).flatMap(arg_0 -> ((GameClientInterface)gateway).transferGuildOwnership(arg_0)).doOnSubscribe(__ -> RocketToast.info(this.minecraft, "Transferring guild: " + this.guild.name())).doOnSuccess(__ -> RocketToast.info(this.minecraft, "Guild transferred")).doOnError(RocketException.class, error -> RocketToast.error(this.minecraft, error.getMessage())).subscribe());
            this.contentConsumer.accept(this);
        }, () -> this.contentConsumer.accept(this))));
        this.deleteButton = Theme.createRedButton((Component)new TextComponent("Delete"), () -> this.contentConsumer.accept(new ConfirmDialogView((Component)new TranslatableComponent("view.guild.your_guild.delete.message", new Object[]{this.guild.name()}), () -> {
            Rocket.gameClientInterface().ifPresent(gateway -> gateway.deleteGuild().doOnSubscribe(__ -> RocketToast.info(this.minecraft, "Deleting guild: " + this.guild.name())).doOnSuccess(__ -> RocketToast.info(this.minecraft, "Guild deleted")).doOnError(RocketException.class, error -> RocketToast.error(this.minecraft, error.getMessage())).subscribe());
            this.contentConsumer.accept(this);
        }, () -> this.contentConsumer.accept(this))));
        this.renameButton = Theme.createBlueButton((Component)new TextComponent("Rename"), () -> this.contentConsumer.accept(new TextDialogView((Component)new TranslatableComponent("view.guild.your_guild.rename.message"), I18n.m_118938_((String)"view.guild.text_dialog.name", (Object[])new Object[0]), result -> {
            Rocket.gameClientInterface().ifPresent(gateway -> gateway.renameGuild(result).doOnSubscribe(__ -> RocketToast.info(this.minecraft, "Renaming guild: " + this.guild.name())).doOnSuccess(__ -> RocketToast.info(this.minecraft, "Guild renamed")).doOnError(RocketException.class, error -> RocketToast.error(this.minecraft, error.getMessage())).subscribe());
            this.contentConsumer.accept(this);
        }, () -> this.contentConsumer.accept(this))));
        this.leaveButton = Theme.createRedButton((Component)new TextComponent("Leave"), () -> this.contentConsumer.accept(new ConfirmDialogView((Component)new TranslatableComponent("view.guild.your_guild.leave.message", new Object[]{this.guild.name()}), () -> {
            Rocket.gameClientInterface().ifPresent(gateway -> gateway.leaveGuild().doOnSubscribe(__ -> RocketToast.info(this.minecraft, "Leaving guild: " + this.guild.name())).doOnSuccess(__ -> RocketToast.info(this.minecraft, "Left guild")).doOnError(RocketException.class, error -> RocketToast.error(this.minecraft, error.getMessage())).subscribe());
            this.contentConsumer.accept(this);
        }, () -> this.contentConsumer.accept(this))));
    }

    private void updateGuild(GameClientInterface gateway, Guild guild) {
        if (guild == null) {
            return;
        }
        if (!guild.equals((Object)this.guild)) {
            this.membersView.clearChildren();
            gateway.getGuildMembers(guild.id()).publishOn(Schedulers.fromExecutor((Executor)this.minecraft)).doOnNext(member -> this.updateMember(gateway, (GuildMember)member)).doOnTerminate(this::layout).subscribeOn(Schedulers.boundedElastic()).subscribe();
        } else {
            this.memberViews.values().forEach(view -> view.updateGuild(guild));
        }
        this.guild = guild;
        if (this.selfMember != null) {
            this.updateInformation(gateway);
        }
    }

    private void updateInformation(GameClientInterface gateway) {
        this.informationView.clearChildren();
        this.informationView.addChild(new TextView(new View.Properties()).setText((FormattedText)new TextComponent("").m_7220_((Component)new TextComponent("Name: ").m_130940_(ChatFormatting.GRAY)).m_130946_(this.guild.name())));
        this.informationView.addChild(new TextView(new View.Properties()).setText((FormattedText)new TextComponent("").m_7220_((Component)new TextComponent("Tag: ").m_130940_(ChatFormatting.GRAY)).m_130946_(this.guild.tag())));
        this.informationView.addChild(new TextView(new View.Properties()).setText((FormattedText)new TextComponent("").m_7220_((Component)new TextComponent("Owner: ").m_130940_(ChatFormatting.GRAY)).m_130946_(this.guild.owner().minecraftProfile().name())));
        ParentView controlsView = new ParentView(new View.Properties().id("controls"));
        this.informationView.addChild(controlsView);
        long permissions = this.guild.getPermissions(this.selfMember);
        if (GuildPermission.RENAME.contains(permissions)) {
            controlsView.forceAddChild(this.renameButton);
        }
        if (this.guild.isOwner(gateway.user())) {
            controlsView.forceAddChild(this.transferButton);
            controlsView.forceAddChild(this.deleteButton);
        } else {
            controlsView.forceAddChild(this.leaveButton);
        }
        this.informationView.layout();
    }

    private void updateMember(GameClientInterface gateway, GuildMember member) {
        MemberView view;
        if (member.user().equals((Object)gateway.user())) {
            this.selfMember = member;
            this.updateInformation(gateway);
        }
        if ((view = this.memberViews.computeIfAbsent(member.user().id(), __ -> new MemberView(this.guild, member))).hasParent()) {
            view.updateMember(member);
        } else {
            view.eventBus().subscribe(RemovedEvent.class, __ -> this.memberViews.remove(member.user().id(), view));
            this.membersView.addChild(view);
        }
    }

    @Override
    protected void added() {
        super.added();
        this.listener = Rocket.gameClientInterfaceFeed().flatMap(api -> Mono.when((Publisher[])new Publisher[]{api.getSocialProfileFeed().publishOn(Schedulers.fromExecutor((Executor)this.minecraft)).doOnNext(profile -> this.updateGuild((GameClientInterface)api, profile.guild())), api.getGuildEventFeed().ofType(GuildMemberUpdateEvent.class).filter(event -> this.guild != null && event.guildId().equals((Object)this.guild.id())).publishOn(Schedulers.fromExecutor((Executor)this.minecraft)).doOnNext(event -> this.updateMember((GameClientInterface)api, event.guildMember()))})).subscribeOn(Schedulers.boundedElastic()).subscribe();
    }

    @Override
    protected void removed() {
        super.removed();
        this.listener.dispose();
    }
}

