/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.connector.client.gui.guild;

import com.craftingdead.immerse.client.gui.screen.Theme;
import com.mojang.authlib.GameProfile;
import io.github.humbleui.skija.FontMgr;
import java.util.concurrent.Executor;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.rocketpowered.common.Guild;
import net.rocketpowered.common.GuildMember;
import net.rocketpowered.common.GuildMemberLeaveEvent;
import net.rocketpowered.common.GuildRank;
import net.rocketpowered.common.UserPresence;
import net.rocketpowered.sdk.Rocket;
import net.rocketpowered.sdk.service.GameClientService;
import reactor.core.Disposable;
import reactor.core.scheduler.Schedulers;
import sm0keysa1m0n.bliss.Color;
import sm0keysa1m0n.bliss.minecraft.view.AvatarView;
import sm0keysa1m0n.bliss.style.selector.StyleNodeState;
import sm0keysa1m0n.bliss.view.ParentView;
import sm0keysa1m0n.bliss.view.TextView;
import sm0keysa1m0n.bliss.view.View;

public class MemberView
extends ParentView {
    private Guild guild;
    private GuildMember member;
    private Disposable removeListener;
    private Disposable presenceListener;
    private final AvatarView avatarView;
    private final TextView nameView;
    private final TextView rankView;

    public MemberView(Guild guild, GuildMember member) {
        super(new View.Properties().styleClasses("item").unscaleBorder(false).focusable(true));
        this.guild = guild;
        this.avatarView = new AvatarView(new View.Properties(), new GameProfile(member.user().minecraftProfile().id(), null));
        this.addChild(this.avatarView);
        ParentView textView = new ParentView(new View.Properties().id("text"));
        this.addChild(textView);
        this.nameView = new TextView(new View.Properties()).setWrap(false).setText(member.user().minecraftProfile().name());
        textView.addChild(this.nameView);
        this.rankView = new TextView(new View.Properties()).setWrap(false);
        textView.addChild(this.rankView);
        this.updateMember(member);
    }

    @Override
    public void styleRefreshed(FontMgr fontManager) {
        this.avatarView.getStyle().defineBorderColorState(Theme.OFFLINE, new StyleNodeState[0]);
        this.nameView.getStyle().color.defineState(Theme.OFFLINE, new StyleNodeState[0]);
    }

    public GuildMember getMember() {
        return this.member;
    }

    public void updateGuild(Guild guild) {
        this.guild = guild;
        this.updateMember(this.member);
    }

    public void updateMember(GuildMember member) {
        this.member = member;
        GuildRank rank = member.rank();
        Color color = Color.WHITE;
        boolean owner = member.user().equals((Object)this.guild.owner());
        if (owner) {
            color = Color.GOLD;
        } else if (rank == GuildRank.DIGNITARY) {
            color = Color.DARK_PURPLE;
        } else if (rank == GuildRank.ENVOY) {
            color = Color.AQUA;
        }
        this.rankView.setText((FormattedText)new TextComponent(owner ? "Owner" : rank.getDisplayName().orElse("")).m_130940_(ChatFormatting.ITALIC));
        this.rankView.getStyle().color.defineState(color, new StyleNodeState[0]);
        this.getStyle().borderLeftColor.defineState(color, new StyleNodeState[0]);
    }

    private void updatePresence(UserPresence presence) {
        Color color = presence.online() ? Theme.ONLINE : Theme.OFFLINE;
        this.avatarView.getStyle().defineBorderColorState(color, new StyleNodeState[0]);
        this.nameView.getStyle().color.defineState(color, new StyleNodeState[0]);
    }

    @Override
    protected void added() {
        super.added();
        this.removeListener = Rocket.gameClientInterfaceFeed().flatMap(GameClientService::getGuildEventFeed).ofType(GuildMemberLeaveEvent.class).filter(event -> event.user().equals((Object)this.member.user())).next().subscribeOn(Schedulers.boundedElastic()).publishOn(Schedulers.fromExecutor((Executor)this.minecraft)).subscribe(__ -> {
            if (this.hasParent()) {
                ParentView parent = this.getParent();
                parent.removeChild(this);
                parent.layout();
            }
        });
        this.presenceListener = Rocket.gameClientInterfaceFeed().flatMap(api -> api.getUserPresenceFeed(this.member.user().id())).subscribeOn(Schedulers.boundedElastic()).publishOn(Schedulers.fromExecutor((Executor)this.minecraft)).subscribe(this::updatePresence);
    }

    @Override
    protected void removed() {
        super.removed();
        this.removeListener.dispose();
        this.presenceListener.dispose();
    }
}

