/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.connector.client.gui.guild;

import com.craftingdead.immerse.client.gui.screen.Theme;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.rocketpowered.common.Guild;
import net.rocketpowered.common.GuildMember;
import net.rocketpowered.common.GuildMemberUpdateEvent;
import net.rocketpowered.common.GuildPermission;
import net.rocketpowered.common.GuildRank;
import net.rocketpowered.connector.client.gui.RocketToast;
import net.rocketpowered.connector.client.gui.guild.MemberView;
import net.rocketpowered.connector.client.gui.guild.TextDialogView;
import net.rocketpowered.sdk.Rocket;
import net.rocketpowered.sdk.interf.GameClientInterface;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import sm0keysa1m0n.bliss.view.ParentView;
import sm0keysa1m0n.bliss.view.TextView;
import sm0keysa1m0n.bliss.view.View;
import sm0keysa1m0n.bliss.view.event.RemovedEvent;

public class ManageMembersView
extends ParentView {
    public static final Component TITLE = new TranslatableComponent("view.guild.manage_members");
    private final ParentView membersListView;
    private final ParentView controlsView;
    private final View promoteButton;
    private final View demoteButton;
    private final View kickButton;
    private final View inviteButton;
    private final Map<ObjectId, MemberView> memberViews = new HashMap<ObjectId, MemberView>();
    @Nullable
    private Guild guild;
    @Nullable
    private GuildMember member;
    @Nullable
    private MemberView selectedMemberView;
    private Disposable listener;

    public ManageMembersView(Consumer<View> viewConsumer) {
        super(new View.Properties().styleClasses("page", "blur"));
        this.addChild(new TextView(new View.Properties().id("title")).setText((FormattedText)TITLE));
        this.membersListView = new ParentView(new View.Properties().id("list"));
        this.addChild(this.membersListView);
        this.controlsView = new ParentView(new View.Properties().id("controls"));
        this.promoteButton = Theme.createBlueButton((Component)new TextComponent("Promote"), () -> Rocket.gameClientInterface().ifPresent(gateway -> gateway.setGuildMemberRank(this.selectedMemberView.getMember().user().id(), this.selectedMemberView.getMember().rank().promote()).subscribe()), "promote-button");
        this.controlsView.addChild(this.promoteButton);
        this.demoteButton = Theme.createRedButton((Component)new TextComponent("Demote"), () -> Rocket.gameClientInterface().ifPresent(gateway -> gateway.setGuildMemberRank(this.selectedMemberView.getMember().user().id(), this.selectedMemberView.getMember().rank().demote()).subscribe()));
        this.controlsView.addChild(this.demoteButton);
        this.kickButton = Theme.createRedButton((Component)new TextComponent("Kick"), () -> Rocket.gameClientInterface().ifPresent(gateway -> gateway.kickGuildMember(this.selectedMemberView.getMember().user().id()).subscribe()));
        this.controlsView.addChild(this.kickButton);
        this.inviteButton = Theme.createBlueButton((Component)new TextComponent("Invite"), () -> viewConsumer.accept(new TextDialogView((Component)new TranslatableComponent("view.guild.manage_members.send_invite.message"), I18n.m_118938_((String)"view.guild.text_dialog.username", (Object[])new Object[0]), result -> {
            if (result.equalsIgnoreCase(this.minecraft.m_91094_().m_92546_())) {
                RocketToast.error(this.minecraft, "Cannot invite yourself");
                viewConsumer.accept(this);
                return;
            }
            Rocket.gameClientInterface().ifPresent(gateway -> gateway.getUserId(result).flatMap(arg_0 -> ((GameClientInterface)gateway).sendGuildInvite(arg_0)).doOnSubscribe(__ -> RocketToast.info(this.minecraft, "Sending invite to: " + result)).doOnSuccess(__ -> RocketToast.info(this.minecraft, "Invite sent")).doOnError(error -> RocketToast.error(this.minecraft, error.getMessage())).subscribe());
            viewConsumer.accept(this);
        }, () -> viewConsumer.accept(this))));
        this.controlsView.addChild(this.inviteButton);
        this.addChild(this.controlsView);
        this.updateSelected();
    }

    protected void updateSelected() {
        this.selectedMemberView = this.membersListView.getChildren().stream().filter(MemberView.class::isInstance).map(MemberView.class::cast).filter(View::isFocused).findAny().orElse(null);
        if (this.selectedMemberView == null) {
            this.promoteButton.setEnabled(false);
            this.demoteButton.setEnabled(false);
            this.kickButton.setEnabled(false);
            return;
        }
        GuildMember selectedMember = this.selectedMemberView.getMember();
        GuildRank selectedMemberRank = selectedMember.rank();
        boolean selectedMemberLower = this.guild.isOwner(this.member) || selectedMemberRank.ordinal() < this.member.rank().ordinal();
        long permissions = this.guild.getPermissions(this.member);
        boolean manageRanks = !this.guild.isOwner(selectedMember) && GuildPermission.MANAGE_RANKS.contains(permissions);
        this.promoteButton.setEnabled(!selectedMemberRank.isHighest() && selectedMemberLower && manageRanks);
        this.demoteButton.setEnabled(!selectedMemberRank.isLowest() && selectedMemberLower && manageRanks);
        this.kickButton.setEnabled(!selectedMember.equals((Object)this.member) && selectedMemberLower && GuildPermission.KICK.contains(permissions));
    }

    private void updateGuild(GameClientInterface gateway, Guild guild) {
        if (guild == null) {
            return;
        }
        if (!guild.equals((Object)this.guild)) {
            this.membersListView.clearChildren();
            gateway.getGuildMembers(guild.id()).publishOn(Schedulers.fromExecutor((Executor)this.minecraft)).doOnNext(member -> this.updateMember(gateway, (GuildMember)member)).doOnTerminate(this::layout).subscribeOn(Schedulers.boundedElastic()).subscribe();
        } else {
            this.memberViews.values().forEach(view -> view.updateGuild(guild));
        }
        this.guild = guild;
    }

    private void updateMember(GameClientInterface gateway, GuildMember member) {
        MemberView view;
        if (member.user().equals((Object)gateway.user())) {
            this.updateSelfMember(member);
        }
        if ((view = this.memberViews.computeIfAbsent(member.user().id(), __ -> new MemberView(this.guild, member))).hasParent()) {
            view.updateMember(member);
        } else {
            view.eventBus().subscribe(RemovedEvent.class, __ -> this.memberViews.remove(member.user().id(), view));
            this.membersListView.addChild(view);
        }
    }

    private void updateSelfMember(GuildMember member) {
        this.member = member;
        long permissions = this.guild.getPermissions(member);
        this.inviteButton.setEnabled(GuildPermission.INVITE.contains(permissions));
        if (GuildPermission.KICK.contains(permissions) || GuildPermission.MANAGE_RANKS.contains(permissions) || GuildPermission.INVITE.contains(permissions)) {
            if (this.controlsView.getParent() != this) {
                this.addChild(this.controlsView);
                this.layout();
            }
        } else if (this.controlsView.getParent() == this) {
            this.removeChild(this.controlsView);
            this.layout();
        }
    }

    @Override
    protected void added() {
        super.added();
        this.listener = Rocket.gameClientInterfaceFeed().flatMap(gateway -> Mono.when((Publisher[])new Publisher[]{gateway.getSocialProfileFeed().publishOn(Schedulers.fromExecutor((Executor)this.minecraft)).doOnNext(profile -> this.updateGuild((GameClientInterface)gateway, profile.guild())), gateway.getGuildEventFeed().ofType(GuildMemberUpdateEvent.class).filter(event -> this.guild != null && event.getGuildId().equals((Object)this.guild.id())).publishOn(Schedulers.fromExecutor((Executor)this.minecraft)).doOnNext(event -> {
            this.updateMember((GameClientInterface)gateway, event.guildMember());
            this.membersListView.layout();
        })})).subscribeOn(Schedulers.boundedElastic()).subscribe();
    }

    @Override
    protected void removed() {
        super.removed();
        this.listener.dispose();
        this.guild = null;
        this.member = null;
        this.selectedMemberView = null;
    }

    @Override
    public boolean mousePressed(double mouseX, double mouseY, int button) {
        this.updateSelected();
        return super.mousePressed(mouseX, mouseY, button);
    }
}

