/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.connector.client.gui.guild;

import com.google.common.base.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.rocketpowered.common.Guild;
import net.rocketpowered.common.GuildInvite;
import net.rocketpowered.common.GuildMember;
import net.rocketpowered.common.GuildPermission;
import net.rocketpowered.common.SocialProfile;
import net.rocketpowered.connector.client.gui.RocketToast;
import net.rocketpowered.connector.client.gui.guild.CreateGuildDialogView;
import net.rocketpowered.connector.client.gui.guild.InvitesView;
import net.rocketpowered.connector.client.gui.guild.ManageMembersView;
import net.rocketpowered.connector.client.gui.guild.YourGuildView;
import net.rocketpowered.sdk.Rocket;
import net.rocketpowered.sdk.interf.GameClientInterface;
import org.jetbrains.annotations.Nullable;
import reactor.core.Disposable;
import reactor.core.scheduler.Schedulers;
import sm0keysa1m0n.bliss.minecraft.view.PanoramaView;
import sm0keysa1m0n.bliss.view.ParentView;
import sm0keysa1m0n.bliss.view.TextView;
import sm0keysa1m0n.bliss.view.View;
import sm0keysa1m0n.bliss.view.event.ActionEvent;

public class GuildView
extends ParentView {
    private final ParentView contentView = new ParentView(new View.Properties().id("content"));
    private final ParentView sideBarView;
    private final YourGuildView yourGuildView = new YourGuildView(this::setContentView);
    private final InvitesView invitesView;
    private final TextView invitesButtonView;
    private final View createGuildButtonView;
    private final View manageMembersButtonView;
    private final View yourGuildButtonView;
    @Nullable
    private Guild guild;
    @Nullable
    private GuildMember selfMember;
    private Disposable profileListener;
    @Nullable
    private Disposable guildMemberListener;

    public GuildView() {
        super(new View.Properties());
        ManageMembersView manageMembersView = new ManageMembersView(this::setContentView);
        this.invitesView = new InvitesView();
        this.addChild(new PanoramaView(new View.Properties(), TitleScreen.f_96716_));
        this.sideBarView = new ParentView(new View.Properties().id("side-bar").styleClasses("blur"));
        this.addChild(this.sideBarView);
        this.manageMembersButtonView = new TextView(new View.Properties().focusable(true)).setText((FormattedText)ManageMembersView.TITLE);
        this.manageMembersButtonView.eventBus().subscribe(ActionEvent.class, event -> this.setContentView(manageMembersView));
        this.yourGuildButtonView = new TextView(new View.Properties().focusable(true)).setText((FormattedText)YourGuildView.TITLE);
        this.yourGuildButtonView.eventBus().subscribe(ActionEvent.class, event -> this.setContentView(this.yourGuildView));
        this.invitesButtonView = new TextView(new View.Properties().focusable(true)).setText((FormattedText)InvitesView.TITLE);
        this.invitesButtonView.eventBus().subscribe(ActionEvent.class, event -> this.setContentView(this.invitesView));
        this.sideBarView.addChild(this.invitesButtonView);
        this.createGuildButtonView = new TextView(new View.Properties().focusable(true)).setText((FormattedText)CreateGuildDialogView.TITLE);
        this.createGuildButtonView.eventBus().subscribe(ActionEvent.class, event -> this.setContentView(new CreateGuildDialogView((name, tag) -> Rocket.gameClientInterface().ifPresentOrElse(connection -> connection.createGuild(name, tag).doOnSubscribe(__ -> RocketToast.info(this.minecraft, "Creating guild: " + name)).doOnSuccess(__ -> RocketToast.info(this.minecraft, "Guild created")).doOnError(error -> RocketToast.error(this.minecraft, error.getMessage())).publishOn(Schedulers.fromExecutor((Executor)this.minecraft)).subscribe(), () -> RocketToast.info(this.minecraft, "Not connected to Rocket")), () -> this.setContentView(this.invitesView))));
        this.sideBarView.addChild(this.createGuildButtonView);
        this.addChild(this.contentView);
        this.setContentView(this.invitesView);
    }

    private void setContentView(View view) {
        this.contentView.replace(view);
    }

    private Component makeInvitesText(Set<GuildInvite> invites) {
        return invites.isEmpty() ? InvitesView.TITLE : InvitesView.TITLE.m_6881_().m_7220_((Component)new TextComponent(" (" + invites.size() + ")").m_130940_(ChatFormatting.LIGHT_PURPLE));
    }

    private void handleProfile(SocialProfile profile, GameClientInterface gateway) {
        this.invitesButtonView.setText((FormattedText)this.makeInvitesText(profile.guildInvites()));
        Guild lastGuild = this.guild;
        this.guild = profile.guild();
        if (this.guild != null && lastGuild != null && !this.guild.owner().equals((Object)lastGuild.owner()) && this.selfMember != null) {
            this.handleGuildMember(this.selfMember);
        }
        if (Objects.equal((Object)lastGuild, (Object)this.guild)) {
            return;
        }
        if (this.guild == null) {
            if (this.guildMemberListener != null) {
                this.guildMemberListener.dispose();
                this.guildMemberListener = null;
            }
            this.setContentView(this.invitesView);
            this.sideBarView.removeChild(this.manageMembersButtonView);
            this.sideBarView.removeChild(this.yourGuildButtonView);
            this.sideBarView.addChild(this.createGuildButtonView);
        } else {
            this.guildMemberListener = gateway.getGuildMemberFeed().publishOn(Schedulers.fromExecutor((Executor)this.minecraft)).doOnNext(this::handleGuildMember).subscribe();
            this.setContentView(this.yourGuildView);
            this.sideBarView.removeChild(this.createGuildButtonView);
            this.sideBarView.addChild(this.yourGuildButtonView);
        }
        this.layout();
    }

    private void handleGuildMember(GuildMember member) {
        this.selfMember = member;
        long permissions = this.guild.getPermissions(member);
        if (GuildPermission.KICK.contains(permissions) || GuildPermission.MANAGE_RANKS.contains(permissions) || GuildPermission.INVITE.contains(permissions)) {
            if (!this.manageMembersButtonView.hasParent()) {
                this.sideBarView.addChild(this.manageMembersButtonView);
                this.layout();
            }
        } else if (this.manageMembersButtonView.hasParent()) {
            this.sideBarView.removeChild(this.manageMembersButtonView);
            this.setContentView(this.yourGuildView);
            this.layout();
        }
    }

    @Override
    protected void added() {
        super.added();
        this.profileListener = Rocket.gameClientInterfaceFeed().flatMap(api -> api.getSocialProfileFeed().publishOn(Schedulers.fromExecutor((Executor)this.minecraft)).doOnNext(profile -> this.handleProfile((SocialProfile)profile, (GameClientInterface)api))).subscribeOn(Schedulers.boundedElastic()).subscribe();
    }

    @Override
    protected void removed() {
        super.removed();
        this.selfMember = null;
        this.guild = null;
        this.profileListener.dispose();
        if (this.guildMemberListener != null) {
            this.guildMemberListener.dispose();
        }
    }
}

