/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.world.level.extension;

import com.craftingdead.immerse.world.level.extension.BaseLandManager;
import com.craftingdead.immerse.world.level.extension.LandSection;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.SortedSet;
import java.util.function.BooleanSupplier;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.storage.IOWorker;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class PersistedLandManager
extends BaseLandManager {
    private static final Logger logger = LogUtils.getLogger();
    private final IOWorker worker;
    private final SortedSet<ChunkPos> dirtyChunks = new ObjectLinkedOpenHashSet();

    public PersistedLandManager(Level level, Path path, boolean sync) {
        super(level);
        this.worker = new IOWorker(path, sync, path.getFileName().toString());
    }

    @Override
    public void tick(BooleanSupplier haveTime) {
        super.tick(haveTime);
        while (!this.dirtyChunks.isEmpty() && haveTime.getAsBoolean()) {
            this.saveChunk(this.dirtyChunks.first());
        }
    }

    @Override
    @Nullable
    protected LandSection getOrLoadSection(long sectionPos) {
        if (this.isSectionOutOfBounds(sectionPos)) {
            return null;
        }
        if (!this.sections.containsKey(sectionPos)) {
            this.loadChunk(SectionPos.m_123184_((long)sectionPos).m_123251_());
        }
        return (LandSection)this.sections.get(sectionPos);
    }

    private void loadChunk(ChunkPos chunkPos) {
        CompoundTag chunkTag;
        try {
            chunkTag = this.worker.m_63533_(chunkPos);
        }
        catch (IOException e) {
            logger.error("Error reading chunk {} data from disk", (Object)chunkPos, (Object)e);
            return;
        }
        for (int i = this.level.m_151560_(); i < this.level.m_151561_(); ++i) {
            this.sections.put(PersistedLandManager.getSectionPos(chunkPos, i), null);
        }
        if (chunkTag != null) {
            this.loadChunk(chunkPos, chunkTag);
        }
    }

    private void loadChunk(ChunkPos chunkPos, CompoundTag chunkTag) {
        ListTag sectionsTag = chunkTag.m_128437_("sections", 10);
        for (int i = 0; i < sectionsTag.size(); ++i) {
            CompoundTag entryTag = sectionsTag.m_128728_(i);
            int sectionY = entryTag.m_128451_("sectionY");
            if (sectionY < this.level.m_151560_() || sectionY >= this.level.m_151561_()) continue;
            long sectionKey = PersistedLandManager.getSectionPos(chunkPos, sectionY);
            LandSection section = (LandSection)LandSection.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)entryTag.m_128469_("section")).getOrThrow(false, arg_0 -> ((Logger)logger).error(arg_0));
            this.sections.put(sectionKey, (Object)section);
        }
    }

    private void saveChunk(ChunkPos chunkPos) {
        this.dirtyChunks.remove(chunkPos);
        CompoundTag chunkTag = new CompoundTag();
        ListTag sectionsTag = new ListTag();
        for (int i = this.level.m_151560_(); i < this.level.m_151561_(); ++i) {
            long key = PersistedLandManager.getSectionPos(chunkPos, i);
            LandSection section = (LandSection)this.sections.get(key);
            if (section == null) continue;
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128405_("sectionY", i);
            entryTag.m_128365_("section", (Tag)LandSection.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)section).getOrThrow(false, arg_0 -> ((Logger)logger).error(arg_0)));
            sectionsTag.add((Object)entryTag);
        }
        chunkTag.m_128365_("sections", (Tag)sectionsTag);
        this.worker.m_63538_(chunkPos, chunkTag);
    }

    @Override
    protected void sectionChanged(long sectionPos) {
        super.sectionChanged(sectionPos);
        LandSection section = (LandSection)this.sections.get(sectionPos);
        if (section != null) {
            this.dirtyChunks.add(SectionPos.m_123184_((long)sectionPos).m_123251_());
        } else {
            logger.warn("No data for position: {}", (Object)SectionPos.m_123184_((long)sectionPos));
        }
    }

    @Override
    public void flush(ChunkPos chunkPos) {
        if (this.dirtyChunks.contains(chunkPos)) {
            this.saveChunk(chunkPos);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.worker.close();
    }
}

