/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.world.level.extension;

import com.craftingdead.core.capability.CapabilityUtil;
import com.craftingdead.immerse.world.level.extension.LandManager;
import com.craftingdead.immerse.world.level.extension.LevelExtensionImpl;
import java.io.IOException;
import java.util.function.BooleanSupplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface LevelExtension
extends AutoCloseable,
INBTSerializable<CompoundTag> {
    public static final Capability<LevelExtension> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<LevelExtension>(){});
    public static final ResourceLocation CAPABILITY_KEY = new ResourceLocation("craftingdeadimmerse", "level_extension");

    public static LevelExtension create(Level level) {
        return new LevelExtensionImpl(level);
    }

    public static LevelExtension getOrThrow(Level level) {
        return (LevelExtension)CapabilityUtil.getOrThrow(CAPABILITY, (ICapabilityProvider)level, LevelExtension.class);
    }

    @Nullable
    public static LevelExtension get(Level level) {
        return (LevelExtension)CapabilityUtil.get(CAPABILITY, (ICapabilityProvider)level, LevelExtension.class);
    }

    public void tick(BooleanSupplier var1);

    public LandManager getLandManager();

    @Override
    public void close() throws IOException;
}

