/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.world.level.extension;

import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.immerse.world.level.block.entity.ImmerseBlockEntityTypes;
import com.craftingdead.immerse.world.level.extension.LandOwner;
import com.craftingdead.immerse.world.level.extension.LandOwnerType;
import com.craftingdead.immerse.world.level.extension.LandOwnerTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SerializableUUID;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.slf4j.Logger;

public class LegacyBase
implements LandOwner {
    public static final Codec<LegacyBase> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SerializableUUID.f_123272_.fieldOf("id").forGetter(LegacyBase::getId), (App)SerializableUUID.f_123272_.fieldOf("ownerId").forGetter(LegacyBase::getOwnerId), (App)SerializableUUID.f_123272_.listOf().xmap(HashSet::new, List::copyOf).fieldOf("members").forGetter(LegacyBase::getMembers), (App)BlockPos.f_121852_.fieldOf("blockPos").forGetter(LegacyBase::getBlockPos), (App)BoundingBox.f_162354_.fieldOf("buildRegion").forGetter(LegacyBase::getBuildRegion)).apply((Applicative)instance, LegacyBase::new));
    private static final Logger logger = LogUtils.getLogger();
    private final UUID id;
    private final UUID ownerId;
    private final Set<UUID> members;
    private final BlockPos blockPos;
    private BoundingBox buildRegion;

    public LegacyBase(UUID ownerId, BlockPos blockPos, int buildRadius) {
        this(UUID.randomUUID(), ownerId, new HashSet<UUID>(), blockPos, new BoundingBox(blockPos).m_191961_(buildRadius));
    }

    public LegacyBase(UUID id, UUID ownerId, Set<UUID> members, BlockPos blockPos, BoundingBox buildRegion) {
        this.id = id;
        this.ownerId = ownerId;
        this.members = members;
        this.blockPos = blockPos;
        this.buildRegion = buildRegion;
    }

    public UUID getOwnerId() {
        return this.ownerId;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public BoundingBox getBuildRegion() {
        return this.buildRegion;
    }

    @Override
    public boolean isAllowedToBuild(UUID playerId, BlockPos blockPos) {
        return (this.members.contains(playerId) || this.ownerId.equals(playerId)) && this.buildRegion.m_71051_((Vec3i)blockPos);
    }

    @Override
    public void playerPlacedBlock(LivingExtension<?, ?> player, BlockPos ... blocks) {
        player.level().m_141902_(this.getBlockPos(), (BlockEntityType)ImmerseBlockEntityTypes.BASE_CENTER.get()).ifPresent(base -> base.playerPlacedBlock(player, blocks));
    }

    @Override
    public void playerRemovedBlock(LivingExtension<?, ?> player, BlockPos ... blocks) {
        player.level().m_141902_(this.getBlockPos(), (BlockEntityType)ImmerseBlockEntityTypes.BASE_CENTER.get()).ifPresent(base -> base.playerRemovedBlock(player, blocks));
    }

    public Set<UUID> getMembers() {
        return this.members;
    }

    @Override
    public LandOwnerType getType() {
        return (LandOwnerType)((Object)LandOwnerTypes.LEGACY_BASE.get());
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public CompoundTag getUpdateTag() {
        CompoundTag tag = new CompoundTag();
        ListTag membersTag = new ListTag();
        for (UUID member : this.members) {
            membersTag.add((Object)NbtUtils.m_129226_((UUID)member));
        }
        tag.m_128365_("members", (Tag)membersTag);
        tag.m_128365_("buildRegion", (Tag)BoundingBox.f_162354_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.buildRegion).getOrThrow(false, arg_0 -> ((Logger)logger).error(arg_0)));
        return tag;
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        ListTag membersTag = tag.m_128437_("members", 11);
        this.members.clear();
        for (Tag memberTag : membersTag) {
            this.members.add(NbtUtils.m_129233_((Tag)memberTag));
        }
        this.buildRegion = (BoundingBox)BoundingBox.f_162354_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("buildRegion")).getOrThrow(false, arg_0 -> ((Logger)logger).error(arg_0));
    }
}

