/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.world.level.extension;

import com.craftingdead.immerse.world.level.extension.LandClaim;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import org.jetbrains.annotations.Nullable;

public class LandSection {
    public static final Codec<LandSection> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LandClaim.CODEC.listOf().fieldOf("landClaims").forGetter(LandSection::getLandClaims)).apply((Applicative)instance, LandSection::new));
    private final List<LandClaim> landClaims = new ObjectArrayList();

    public LandSection() {
    }

    public LandSection(List<LandClaim> landClaims) {
        this.landClaims.addAll(landClaims);
    }

    private List<LandClaim> getLandClaims() {
        return this.landClaims;
    }

    @Nullable
    public LandClaim getLandClaim(BlockPos blockPos) {
        for (LandClaim claim : this.landClaims) {
            if (!claim.boundingBox().m_71051_((Vec3i)blockPos)) continue;
            return claim;
        }
        return null;
    }

    public boolean registerLandClaim(LandClaim landClaim) {
        for (LandClaim otherRegion : this.landClaims) {
            if (!otherRegion.boundingBox().m_71049_(landClaim.boundingBox())) continue;
            return false;
        }
        this.landClaims.add(landClaim);
        return true;
    }

    public boolean removeLandClaim(LandClaim landClaim) {
        return this.landClaims.remove(landClaim);
    }
}

