/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.world.level.extension;

import com.craftingdead.immerse.world.level.extension.LandClaim;
import com.craftingdead.immerse.world.level.extension.LandOwner;
import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.Nullable;

public interface LandManager
extends AutoCloseable {
    public void tick(BooleanSupplier var1);

    public void registerLandOwner(LandOwner var1);

    public CompletionStage<Boolean> removeLandOwner(UUID var1);

    @Nullable
    public LandOwner getLandOwner(UUID var1);

    public CompletionStage<ClaimResult> registerLandClaim(LandClaim var1);

    public CompletionStage<Boolean> removeLandClaim(LandClaim var1);

    public CompletionStage<Void> destroyBlocks(BlockPos ... var1);

    @Nullable
    public LandClaim getLandClaimAt(BlockPos var1);

    default public boolean isLandClaimed(BlockPos blockPos) {
        return this.getLandClaimAt(blockPos) != null;
    }

    default public Optional<LandOwner> getLandOwnerAt(BlockPos blockPos) {
        LandClaim landClaim = this.getLandClaimAt(blockPos);
        return landClaim == null ? Optional.empty() : Optional.ofNullable(this.getLandOwner(landClaim.ownerId()));
    }

    public CompoundTag save();

    public void load(CompoundTag var1);

    public void writeToBuf(FriendlyByteBuf var1);

    public void readFromBuf(FriendlyByteBuf var1);

    public void writeChunkToBuf(ChunkPos var1, FriendlyByteBuf var2);

    public void readChunkFromBuf(ChunkPos var1, FriendlyByteBuf var2);

    public void flush(ChunkPos var1);

    @Override
    public void close() throws IOException;

    public static enum ClaimResult {
        OUT_OF_BOUNDS,
        ALREADY_CLAIMED,
        SUCCESS;

    }
}

