/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.world.level.block.entity;

import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.immerse.game.survival.SurvivalPlayerHandler;
import com.craftingdead.immerse.world.level.block.entity.ImmerseBlockEntityTypes;
import com.craftingdead.immerse.world.level.extension.LandClaim;
import com.craftingdead.immerse.world.level.extension.LandManager;
import com.craftingdead.immerse.world.level.extension.LegacyBase;
import com.craftingdead.immerse.world.level.extension.LevelExtension;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseCenterBlockEntity
extends BlockEntity {
    private static final int RADIUS = 35;
    private static final int BUILD_RADIUS = 7;
    @Nullable
    private UUID baseId;
    private final Set<BlockPos> playerBlocks = new HashSet<BlockPos>();

    public BaseCenterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ImmerseBlockEntityTypes.BASE_CENTER.get(), pos, state);
    }

    public void placed(LivingEntity livingEntity) {
        SurvivalPlayerHandler playerHandler;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.m_5661_((Component)new TranslatableComponent("message.creating_base"), false);
            playerHandler = (SurvivalPlayerHandler)PlayerExtension.getOrThrow((Player)player).getHandlerOrThrow(SurvivalPlayerHandler.TYPE);
            LegacyBase existingBase = playerHandler.getBase().orElse(null);
            if (existingBase != null) {
                player.m_5661_((Component)new TranslatableComponent("message.already_own_base", new Object[]{existingBase.getBlockPos().m_123344_()}).m_130940_(ChatFormatting.RED), true);
                return;
            }
        } else {
            playerHandler = null;
        }
        LandManager landManager = LevelExtension.getOrThrow(this.f_58857_).getLandManager();
        LegacyBase base = new LegacyBase(livingEntity.m_142081_(), this.m_58899_(), 7);
        this.baseId = base.getId();
        landManager.registerLandOwner(base);
        landManager.registerLandClaim(new LandClaim(new BoundingBox(this.m_58899_()).m_191961_(35), this.baseId)).whenCompleteAsync((result, exception) -> {
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                player.m_5661_((Component)(switch (result) {
                    default -> throw new IncompatibleClassChangeError();
                    case LandManager.ClaimResult.ALREADY_CLAIMED -> new TranslatableComponent("message.land_already_claimed").m_130940_(ChatFormatting.RED);
                    case LandManager.ClaimResult.OUT_OF_BOUNDS -> new TranslatableComponent("message.land_out_of_bounds").m_130940_(ChatFormatting.RED);
                    case LandManager.ClaimResult.SUCCESS -> {
                        if (playerHandler != null) {
                            playerHandler.setBaseId(this.baseId);
                        }
                        yield new TranslatableComponent("message.base_creation_succeeded").m_130940_(ChatFormatting.GREEN);
                    }
                }), true);
            }
        }, (Executor)this.f_58857_.m_142572_());
    }

    public void removed() {
        if (this.baseId != null) {
            LandManager landManager = LevelExtension.getOrThrow(this.f_58857_).getLandManager();
            landManager.removeLandOwner(this.baseId);
        }
    }

    public void playerPlacedBlock(LivingExtension<?, ?> player, BlockPos ... posArray) {
        for (BlockPos pos : posArray) {
            this.playerBlocks.add(pos.m_7949_());
        }
    }

    public void playerRemovedBlock(LivingExtension<?, ?> player, BlockPos ... posArray) {
        for (BlockPos pos : posArray) {
            this.playerBlocks.remove(pos);
        }
    }

    public void destroyPlayerBlocks() {
        LevelExtension.getOrThrow(this.f_58857_).getLandManager().destroyBlocks(this.playerBlocks.toArray(new BlockPos[0]));
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        if (this.baseId != null) {
            tag.m_128362_("baseId", this.baseId);
        }
        ListTag blockList = new ListTag();
        for (BlockPos pos : this.playerBlocks) {
            blockList.add((Object)new IntArrayTag(new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}));
        }
        tag.m_128365_("blocks", (Tag)blockList);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128403_("baseId")) {
            this.baseId = tag.m_128342_("baseId");
        }
        if (tag.m_128441_("blocks")) {
            ListTag blockList = tag.m_128437_("blocks", 11);
            for (int i = 0; i < blockList.size(); ++i) {
                int[] pos = blockList.m_128767_(i);
                if (pos.length != 3) continue;
                this.playerBlocks.add(new BlockPos(pos[0], pos[1], pos[2]));
            }
        }
    }
}

