/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.world.action;

import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.immerse.util.BlockUtil;
import com.craftingdead.immerse.world.action.BuildAction;
import com.craftingdead.immerse.world.action.BuildActionType;
import com.craftingdead.immerse.world.action.BuildDoorWallActionType;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Rotation;

public class BuildDoorWallAction
extends BuildAction {
    public static final Set<BlockPos> WALL_OFFSETS = Set.of(new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(1, 1, 0), new BlockPos(-1, 1, 0), new BlockPos(0, 2, 0), new BlockPos(1, 2, 0), new BlockPos(-1, 2, 0));
    private final BuildDoorWallActionType type;

    protected BuildDoorWallAction(LivingExtension<?, ?> performer, BlockPlaceContext context, BuildDoorWallActionType type) {
        super(performer, context);
        this.type = type;
    }

    @Override
    protected List<BuildAction.Placement> createPlacements() {
        Rotation rotation = BlockUtil.getRotation(this.performer().entity().m_6350_());
        BlockPos clickedPos = this.getContext().m_8083_();
        ImmutableList.Builder placements = ImmutableList.builder();
        for (BlockPos offset : WALL_OFFSETS) {
            BlockPos pos = offset.m_7954_(rotation).m_141952_((Vec3i)clickedPos);
            BuildAction.Placement placement = this.createPlacement(pos, this.type.getWallBlock());
            if (placement == null) {
                return null;
            }
            placements.add((Object)placement);
        }
        BuildAction.Placement doorPlacement = this.createPlacement(this.getContext().m_8083_(), this.type.getDoorBlock());
        if (doorPlacement == null) {
            return null;
        }
        placements.add((Object)doorPlacement);
        return placements.build();
    }

    @Override
    public BuildActionType type() {
        return this.type;
    }
}

