/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.world.action;

import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.immerse.util.BlockUtil;
import com.craftingdead.immerse.world.action.BuildAction;
import com.craftingdead.immerse.world.action.BuildActionType;
import com.craftingdead.immerse.world.action.BuildCuboidActionType;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Rotation;
import org.jetbrains.annotations.Nullable;

public class BuildCuboidAction
extends BuildAction {
    private final BuildCuboidActionType type;

    public BuildCuboidAction(LivingExtension<?, ?> performer, BlockPlaceContext context, BuildCuboidActionType type) {
        super(performer, context);
        this.type = type;
    }

    @Override
    @Nullable
    protected List<BuildAction.Placement> createPlacements() {
        Rotation rotation = BlockUtil.getRotation(this.performer().entity().m_6350_());
        BlockPos clickedPos = this.getContext().m_8083_();
        BlockPos minPos = this.type.getMinOffset().m_7954_(rotation).m_141952_((Vec3i)clickedPos);
        BlockPos maxPos = this.type.getMaxOffset().m_7954_(rotation).m_141952_((Vec3i)clickedPos);
        ImmutableList.Builder placements = ImmutableList.builder();
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)minPos, (BlockPos)maxPos)) {
            BuildAction.Placement placement = this.createPlacement(pos, this.type.getBlock());
            if (placement == null) {
                return null;
            }
            placements.add((Object)placement);
        }
        return placements.build();
    }

    @Override
    public BuildActionType type() {
        return this.type;
    }
}

